/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.doc.model;

import cn.gtmap.ai.core.utils.doc.enums.ChartsTypeEnum;
import cn.gtmap.ai.core.utils.doc.model.SeriesDatas;
import cn.gtmap.estateplat.core.ex.AppException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ChartsData {
    private String chartName;
    private String title;
    private ChartsTypeEnum chartsTypeEnum;
    private List<String> categories;
    private Map<String, SeriesDatas> seriesDatas;

    public ChartsData(String chartName, String title, ChartsTypeEnum chartsTypeEnum, List<String> categories, Map<String, SeriesDatas> seriesDatas) {
        this.chartName = chartName;
        this.title = title;
        this.chartsTypeEnum = chartsTypeEnum;
        this.categories = categories;
        this.seriesDatas = seriesDatas;
    }

    public static ChartsData newInstance(String chartName, String title, ChartsTypeEnum chartsTypeEnum, List<String> categories, Map<String, SeriesDatas> seriesDatas) {
        if (StringUtils.isBlank((CharSequence)chartName)) {
            throw new AppException("\u56fe\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(categories)) {
            throw new AppException("\u56fe\u8868\u6570\u636e\u7cfb\u5217\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty(seriesDatas)) {
            throw new AppException("\u56fe\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Map.Entry<String, SeriesDatas> seriesData : seriesDatas.entrySet()) {
            if (categories.size() == seriesData.getValue().getDatas().size()) continue;
            throw new AppException("\u6570\u636e\u7cfb\u5217\u4e0e\u6570\u636e\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        return new ChartsData(chartName, title, chartsTypeEnum, categories, seriesDatas);
    }

    public String getChartName() {
        return this.chartName;
    }

    public String getTitle() {
        return this.title;
    }

    public ChartsTypeEnum getChartsTypeEnum() {
        return this.chartsTypeEnum;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Map<String, SeriesDatas> getSeriesDatas() {
        return this.seriesDatas;
    }
}

