/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.doc;

import com.gtis.common.util.UUIDGenerator;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import com.spire.doc.Document;
import com.spire.doc.FileFormat;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.RFonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeUtil {
    public static final String PICWATERMARK = "picWatermark";
    public static final String WATERMARK_FONTSIZE = "FontSize";
    public static final String WATERMARK_FACTOR = "Factor";
    public static final String WATERMARK = "watermark";
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeUtil.class);

    public static byte[] convertDocxToPDF(byte[] doxcData, String printPath, String modelName) {
        byte[] pdfData = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(doxcData);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            LOGGER.info("{}\u6253\u5370word\u8f6cpdf\u91c7\u7528\u5feb\u901f\u65b9\u6848", (Object)modelName);
            XWPFDocument document = new XWPFDocument((InputStream)is);
            PdfOptions options = PdfOptions.create();
            options.fontProvider((familyName, encoding, size, style, color) -> {
                try {
                    BaseFont baseFont = BaseFont.createFont((String)(printPath + File.separator + OfficeUtil.getFont(familyName) + ",0"), (String)encoding, (boolean)true);
                    return new Font(baseFont, size, style, color);
                }
                catch (Exception e) {
                    LOGGER.error("convertDocxToPDF - Exception:", (Object)e.getMessage());
                    BaseFont baseFont = null;
                    try {
                        baseFont = BaseFont.createFont((String)(printPath + OfficeUtil.getFont("\u5b8b\u4f53") + ",0"), (String)"", (boolean)true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new Font(baseFont, size, style, color);
                }
            });
            PdfConverter.getInstance().convert(document, (OutputStream)os, (Options)options);
            pdfData = os.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("word\u8f6c\u4e3apdf\u5931\u8d25");
        }
        return pdfData;
    }

    public static byte[] saveDocxToPDF(byte[] doxcData) {
        byte[] pdfData = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(doxcData);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Document doc = new Document();
            doc.loadFromStream((InputStream)is, FileFormat.Docx);
            doc.saveToFile((OutputStream)os, FileFormat.PDF);
            pdfData = os.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("word\u8f6c\u4e3apdf\u5931\u8d25");
        }
        return pdfData;
    }

    public static void convertDocxToPDF(InputStream wordIs, OutputStream pdfOs, String printPath) {
        if (wordIs == null) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230WORD\u6587\u4ef6\u6d41");
            return;
        }
        try {
            WordprocessingMLPackage mlPackage = WordprocessingMLPackage.load((InputStream)wordIs);
            OfficeUtil.configSimSunFont(mlPackage, OfficeUtil.getFontMapper(printPath));
            FOSettings foSettings = Docx4J.createFOSettings();
            foSettings.setWmlPackage((OpcPackage)mlPackage);
            Docx4J.toFO((FOSettings)foSettings, (OutputStream)pdfOs, (int)1);
        }
        catch (Exception e) {
            LOGGER.error("word\u8f6c\u4e3apdf\u5931\u8d25:", (Object)e.getMessage());
        }
    }

    private static void configSimSunFont(WordprocessingMLPackage wordMLPackage, Mapper fontMapper) throws Exception {
        wordMLPackage.setFontMapper(fontMapper);
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rfonts.setAsciiTheme(null);
        rfonts.setAscii("SimSun");
        wordMLPackage.getMainDocumentPart().getPropertyResolver().getDocumentDefaultRPr().setRFonts(rfonts);
    }

    public static Mapper getFontMapper(String printPath) {
        try {
            String fontFamily = "SimSun";
            URL simsunUrl = new URL("file:" + printPath + File.separator + "simsun.ttc");
            PhysicalFonts.addPhysicalFonts((String)fontFamily, (URL)simsunUrl);
            PhysicalFont simsunFont = PhysicalFonts.get((String)fontFamily);
            URL simheiUrl = new URL("file:" + printPath + File.separator + "simhei.ttf");
            PhysicalFonts.addPhysicalFonts((String)"SimHei", (URL)simheiUrl);
            PhysicalFont simHeiFont = PhysicalFonts.get((String)"SimHei");
            URL msyhUrl = new URL("file:" + printPath + File.separator + "msyh.ttf");
            PhysicalFonts.addPhysicalFonts((String)"Msyh", (URL)msyhUrl);
            PhysicalFont msyhFont = PhysicalFonts.get((String)"Msyh");
            URL simkaiUrl = new URL("file:" + printPath + File.separator + "simkai.ttf");
            PhysicalFonts.addPhysicalFonts((String)"Simkai", (URL)simkaiUrl);
            PhysicalFont simkaiFont = PhysicalFonts.get((String)"Simkai");
            URL simliUrl = new URL("file:" + printPath + File.separator + "simli.ttf");
            PhysicalFonts.addPhysicalFonts((String)"Simli", (URL)simliUrl);
            PhysicalFont simliFont = PhysicalFonts.get((String)"Simli");
            URL simfangUrl = new URL("file:" + printPath + File.separator + "simfang.ttf");
            PhysicalFonts.addPhysicalFonts((String)"Simfang", (URL)simfangUrl);
            PhysicalFont simfangFont = PhysicalFonts.get((String)"Simfang");
            URL youyuanUrl = new URL("file:" + printPath + File.separator + "youyuan.ttf");
            PhysicalFonts.addPhysicalFonts((String)"Youyuan", (URL)youyuanUrl);
            PhysicalFont youyuanFont = PhysicalFonts.get((String)"Youyuan");
            IdentityPlusMapper fontMapper = new IdentityPlusMapper();
            fontMapper.put("\u5b8b\u4f53", simsunFont);
            fontMapper.put("\u9ed1\u4f53", simHeiFont);
            fontMapper.put("\u5fae\u8f6f\u96c5\u9ed1", msyhFont);
            fontMapper.put("\u6977\u4f53", simkaiFont);
            fontMapper.put("\u96b6\u4e66", simliFont);
            fontMapper.put("\u4eff\u5b8b_GB2312", simfangFont);
            fontMapper.put("\u5e7c\u5706", youyuanFont);
            return fontMapper;
        }
        catch (Exception e) {
            LOGGER.warn("\u76ee\u5f55\u65e0\u6307\u5b9aPDF\u6253\u5370\u9700\u8981\u5b57\u4f53\uff1a{}", (Object)printPath);
            return OfficeUtil.getFontMapper();
        }
    }

    public static String getFont(String fontName) {
        String foontFileName = "simsun.ttc";
        switch (fontName) {
            case "\u5b8b\u4f53": {
                foontFileName = "simsun.ttc";
                break;
            }
            case "\u9ed1\u4f53": {
                foontFileName = "simhei.ttf";
                break;
            }
            case "\u5fae\u8f6f\u96c5\u9ed1": {
                foontFileName = "msyh.ttf";
                break;
            }
            case "\u6977\u4f53": {
                foontFileName = "simkai.ttf";
                break;
            }
            case "\u96b6\u4e66": {
                foontFileName = "simli.ttf";
                break;
            }
            case "\u4eff\u5b8b": {
                foontFileName = "simfang.ttf";
                break;
            }
            case "\u5e7c\u5706": {
                foontFileName = "youyuan.ttf";
                break;
            }
            default: {
                foontFileName = "simsun.ttc";
            }
        }
        return foontFileName;
    }

    public static Map getFontMap() {
        HashMap<String, String> fontMap = new HashMap<String, String>();
        fontMap.put("SimSun", "\u5b8b\u4f53");
        fontMap.put("SimHei", "\u9ed1\u4f53");
        fontMap.put("Msyh", "\u5fae\u8f6f\u96c5\u9ed1");
        fontMap.put("SimKai", "\u6977\u4f53");
        fontMap.put("SimLi", "\u96b6\u4e66");
        fontMap.put("SimFang", "\u4eff\u5b8b_GB2312");
        fontMap.put("YouYuan", "\u5e7c\u5706");
        return fontMap;
    }

    private static Mapper getFontMapper() {
        IdentityPlusMapper fontMapper = new IdentityPlusMapper();
        fontMapper.put("\u5fae\u8f6f\u96c5\u9ed1", PhysicalFonts.get((String)"Microsoft Yahei"));
        fontMapper.put("\u9ed1\u4f53", PhysicalFonts.get((String)"SimHei"));
        fontMapper.put("\u6977\u4f53", PhysicalFonts.get((String)"KaiTi"));
        fontMapper.put("\u96b6\u4e66", PhysicalFonts.get((String)"LiSu"));
        fontMapper.put("\u5b8b\u4f53", PhysicalFonts.get((String)"SimSun"));
        fontMapper.put("\u5b8b\u4f53\u6269\u5c55", PhysicalFonts.get((String)"simsun-extB"));
        fontMapper.put("\u65b0\u5b8b\u4f53", PhysicalFonts.get((String)"NSimSun"));
        fontMapper.put("\u4eff\u5b8b", PhysicalFonts.get((String)"FangSong"));
        fontMapper.put("\u4eff\u5b8b_GB2312", PhysicalFonts.get((String)"FangSong_GB2312"));
        fontMapper.put("\u5e7c\u5706", PhysicalFonts.get((String)"YouYuan"));
        fontMapper.put("\u534e\u6587\u5b8b\u4f53", PhysicalFonts.get((String)"STSong"));
        fontMapper.put("\u534e\u6587\u4eff\u5b8b", PhysicalFonts.get((String)"STFangsong"));
        fontMapper.put("\u534e\u6587\u4e2d\u5b8b", PhysicalFonts.get((String)"STZhongsong"));
        fontMapper.put("\u534e\u6587\u884c\u6977", PhysicalFonts.get((String)"STXingkai"));
        return fontMapper;
    }

    public static String generateWordFileName(String printPath) {
        return printPath + "temp/" + UUIDGenerator.generate18() + ".docx";
    }

    public static String generatePdfFileName(String printPath) {
        return printPath + "temp/" + UUIDGenerator.generate18() + ".pdf";
    }

    public static void addWaterMarkToPdfFile(String pdfFilePath, String waterMark, String fontPath) {
        OfficeUtil.appendWaterMark(pdfFilePath, waterMark, fontPath, 30.0f, 1.0f);
    }

    public static void addWaterMarkConfigToPdfFile(String pdfFilePath, Map<String, Object> pdfData, String fontPath) {
        String waterMark = (String)pdfData.get(WATERMARK);
        String font = "";
        float fontSize = 30.0f;
        float factor = 1.0f;
        if (StringUtils.isNotBlank((CharSequence)waterMark)) {
            String[] tempArr = waterMark.split("_");
            font = tempArr[0];
            if (tempArr.length > 1) {
                for (int i = 1; i < tempArr.length; ++i) {
                    String factorTemp;
                    String fontSizeTemp;
                    String items = tempArr[i];
                    if (items.startsWith(WATERMARK_FONTSIZE) && NumberUtils.isNumber((String)(fontSizeTemp = items.substring(WATERMARK_FONTSIZE.length())))) {
                        fontSize = Float.parseFloat(fontSizeTemp);
                    }
                    if (!items.startsWith(WATERMARK_FACTOR) || !NumberUtils.isNumber((String)(factorTemp = items.substring(WATERMARK_FACTOR.length())))) continue;
                    factor = Float.parseFloat(factorTemp);
                }
            }
            OfficeUtil.appendWaterMark(pdfFilePath, font, fontPath, fontSize, factor);
        } else {
            LOGGER.info("PDF{}\u672a\u8bbe\u7f6e\u6c34\u5370watermark\u5b57\u6bb5", (Object)pdfFilePath);
        }
    }

    public static void addWaterMarkToPdfFileWithFontSzie(String pdfFilePath, String waterMark, String fontPath, float fontSzie) {
        float factor = (float)Math.sin(0.7853981633974483);
        OfficeUtil.appendWaterMark(pdfFilePath, waterMark, fontPath, fontSzie, factor);
    }

    private static void appendWaterMark(String pdfFilePath, String waterMark, String fontPath, float fontSize, float factor) {
        File pdfFile;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pdfFilePath, waterMark, fontPath})) {
            // empty if block
        }
        if (!(pdfFile = new File(pdfFilePath)).exists()) {
            // empty if block
        }
        try {
            PDDocument doc = PDDocument.load((File)pdfFile);
            doc.setAllSecurityToBeRemoved(true);
            for (PDPage page : doc.getPages()) {
                PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
                PDType0Font font = PDType0Font.load((PDDocument)doc, (InputStream)new FileInputStream(fontPath + "simsun.ttf"), (boolean)true);
                PDResources resources = page.getResources();
                PDExtendedGraphicsState r0 = new PDExtendedGraphicsState();
                r0.setNonStrokingAlphaConstant(Float.valueOf(0.5f));
                r0.setAlphaSourceFlag(true);
                cs.setGraphicsStateParameters(r0);
                cs.setNonStrokingColor(220, 220, 220);
                cs.beginText();
                cs.setFont((PDFont)font, fontSize);
                float h = (float)waterMark.length() * fontSize;
                for (int i = 0; i <= 5; ++i) {
                    cs.setTextMatrix(Matrix.getRotateInstance((double)-150.0, (float)(i * 200), (float)0.0f));
                    cs.showText(waterMark);
                    for (int j = 0; j < 10; ++j) {
                        float ty = (float)j * h * factor;
                        cs.setTextMatrix(Matrix.getRotateInstance((double)-150.0, (float)(i * 200), (float)ty));
                        cs.showText(waterMark);
                    }
                }
                cs.endText();
                cs.restoreGraphicsState();
                cs.close();
            }
            doc.save(pdfFile);
        }
        catch (Exception e) {
            LOGGER.error("PDF{}\u6dfb\u52a0\u6c34\u5370\u5931\u8d25: {}", (Object)pdfFilePath, (Object)e.getMessage());
        }
    }

    public static void addPicWaterMarkConfigToPdfFile(String pdfFilePath, Map<String, Object> pdfData, String bgPath) {
        try {
            String waterMark = (String)pdfData.get(PICWATERMARK);
            if (StringUtils.isNotBlank((CharSequence)waterMark)) {
                String tempPdfWaterFileName = OfficeUtil.generatePdfFileName(bgPath);
                PdfReader reader = new PdfReader(pdfFilePath);
                PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(tempPdfWaterFileName));
                String imagePath = bgPath + waterMark;
                Image img = Image.getInstance((String)imagePath);
                img.setAbsolutePosition(0.0f, 0.0f);
                Rectangle pageRect = null;
                PdfGState gs = new PdfGState();
                float fillOpacity = 0.7f;
                gs.setFillOpacity(fillOpacity);
                gs.setStrokeOpacity(0.1f);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    pageRect = reader.getPageSizeWithRotation(i);
                    PdfContentByte under = stamp.getUnderContent(i);
                    under.saveState();
                    under.setGState(gs);
                    img.scaleAbsolute(pageRect.getWidth(), pageRect.getHeight());
                    under.addImage(img);
                }
                stamp.close();
                reader.close();
                OfficeUtil.addPicWaterMarkConfigToPdfFileBack(pdfFilePath, tempPdfWaterFileName);
            } else {
                LOGGER.info("PDF{}\u672a\u8bbe\u7f6e\u56fe\u7247\u6c34\u5370picwatermark\u5b57\u6bb5", (Object)pdfFilePath);
            }
        }
        catch (Exception e) {
            LOGGER.error("PDF{}\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u5931\u8d25: {}", (Object)pdfFilePath, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPicWaterMarkConfigToPdfFileBack(String pdfFilePath, String tempPdfWaterFileName) throws Exception {
        try {
            File orgPdfFile = new File(pdfFilePath);
            if (orgPdfFile.exists()) {
                boolean bl = orgPdfFile.delete();
            }
            PdfReader newPdfReader = new PdfReader(tempPdfWaterFileName);
            PdfStamper newStamp = new PdfStamper(newPdfReader, (OutputStream)new FileOutputStream(pdfFilePath));
            newStamp.close();
            newPdfReader.close();
        }
        catch (Exception e) {
            LOGGER.error("addPicWaterMarkConfigToPdfFileBack - Exception:", (Object)e.getMessage());
        }
        finally {
            File tempPdfFile = new File(tempPdfWaterFileName);
            if (tempPdfFile.exists()) {
                tempPdfFile.delete();
            }
        }
    }

    public static BigDecimal[] getInCellTableColumnWidth(XWPFTable table, List<Map<String, Object>> tableData, int cellLocationRow, int cellLocationCol, int colNum) {
        double inCellWith = table.getRow(cellLocationRow).getCell(cellLocationCol).getWidthDecimal();
        BigDecimal[] colWidths = new BigDecimal[colNum];
        Map<String, Object> fieldNameMap = tableData.get(0);
        Iterator<Map.Entry<String, Object>> iterator = fieldNameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            int colVal;
            String[] field = iterator.next().getKey().split("_");
            if (field.length != 2 && field.length != 3) {
                LOGGER.error("\u89e3\u6790\u5185\u5d4c\u8868\u683c\u5b57\u6bb5\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1axml\u5b57\u6bb5\u540d\u914d\u7f6e\u9519\u8bef");
            }
            if ((colVal = Integer.parseInt(field[1])) > 100) {
                LOGGER.error("\u89e3\u6790\u5185\u5d4c\u8868\u683c\u5b57\u6bb5\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5217\u5bbd\u5ea6\u8bbe\u7f6e\u8d85\u51fa100%");
            }
            if (2 == field.length) {
                colWidths[colVal] = new BigDecimal(Double.toString(inCellWith)).divide(new BigDecimal(Integer.toString(colNum)), 0, 4);
                continue;
            }
            colWidths[colVal] = new BigDecimal(Double.toString(Double.parseDouble(field[2]))).multiply(new BigDecimal(Double.toString(inCellWith))).divide(new BigDecimal(Integer.toString(100)), 0, 4);
        }
        return colWidths;
    }
}

