/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.user.application.impl;

import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.LoginSystemEnum;
import cn.gtmap.ai.core.enums.ZdEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="UserServiceImpl")
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ServiceFactory serviceFactory;

    @Override
    public UserInfoDto getCurrentUser() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.nonNull(request)) {
            LoginResultDto loginResultDto = this.getLoginResultDto(request);
            if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                    return this.getUserByUserid(loginResultDto.getClientId());
                }
                return loginResultDto.getUserInfoDto();
            }
            if (Objects.nonNull(loginResultDto) && StringUtils.isNotBlank((CharSequence)loginResultDto.getToken())) {
                String yydm = this.redisUtils.getStringValue(UserRedisContants.getApiauthYydmBySessionPrefixRedisKey(request.getSession().getId()));
                LoginSystemEnum loginSystemEnum = ZdEnum.valueOf(yydm, LoginSystemEnum.class);
                AuthService authService = Objects.nonNull(loginSystemEnum) ? this.serviceFactory.getSystemAuthService(loginSystemEnum) : this.serviceFactory.getAuthService();
                if (StringUtils.isNotBlank((CharSequence)loginResultDto.getToken())) {
                    return authService.getUserInfoByToken(loginResultDto.getToken());
                }
            }
        }
        return null;
    }

    private LoginResultDto getLoginResultDto(HttpServletRequest request) {
        if (Objects.nonNull(request)) {
            String key = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
            String token = this.redisUtils.getStringValue(key);
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getHeader("token");
            }
            if (StringUtils.isBlank((CharSequence)token)) {
                token = (String)request.getAttribute("token");
            }
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getParameter("token");
            }
            if (StringUtils.isNotBlank((CharSequence)token)) {
                token = token.replace(" ", "+");
            }
            log.info("****getCurrentUser*****token:{} ", (Object)token);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                LoginResultDto loginResultDto;
                String userInfo = this.redisUtils.getStringValue(UserRedisContants.getUserinfoByTokenPrefixRedisKey(token));
                log.info("****getCurrentUser*****userInfo:{} ", (Object)userInfo);
                if (StringUtils.isNotBlank((CharSequence)userInfo) && Objects.nonNull(loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class)) && loginResultDto.isSuccesss()) {
                    return loginResultDto;
                }
                loginResultDto = new LoginResultDto();
                loginResultDto.setToken(token);
                return loginResultDto;
            }
        }
        return null;
    }

    @Override
    public UserInfoDto getUserByToken(String token) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            String yydm;
            LoginSystemEnum loginSystemEnum;
            token = token.replace(" ", "+");
            log.info("****getUserByToken*****token:{} ", (Object)token);
            String userInfo = this.redisUtils.getStringValue(UserRedisContants.getUserinfoByTokenPrefixRedisKey(token));
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                log.info("****getUserByToken*****userInfo:{} ", (Object)userInfo);
                LoginResultDto loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class);
                if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                    if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                        return this.getUserByUserid(loginResultDto.getClientId());
                    }
                    return loginResultDto.getUserInfoDto();
                }
            }
            AuthService authService = Objects.nonNull(loginSystemEnum = ZdEnum.valueOf(yydm = this.redisUtils.getStringValue(UserRedisContants.getApiauthYydmBySessionPrefixRedisKey(request.getSession().getId())), LoginSystemEnum.class)) ? this.serviceFactory.getSystemAuthService(loginSystemEnum) : this.serviceFactory.getAuthService();
            return authService.getUserInfoByToken(token);
        }
        return null;
    }

    @Override
    public UserInfoDto getUserByUserid(String userId) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String yydm = this.redisUtils.getStringValue(UserRedisContants.getApiauthYydmBySessionPrefixRedisKey(request.getSession().getId()));
        LoginSystemEnum loginSystemEnum = ZdEnum.valueOf(yydm, LoginSystemEnum.class);
        AuthService authService = Objects.nonNull(loginSystemEnum) ? this.serviceFactory.getSystemAuthService(loginSystemEnum) : this.serviceFactory.getAuthService();
        return authService.getUserInfoByUserId(userId);
    }
}

