/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.enums.FileTypeEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="testStorageServiceImpl")
public class TestStorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(TestStorageServiceImpl.class);
    @Autowired
    private ServiceFactory serviceFactory;

    @Override
    public StorageModel uploadFile(MultiPartModel multiPartModel) {
        return this.serviceFactory.getStorageService().uploadFile(multiPartModel);
    }

    @Override
    public StorageModel createFolder(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public MultiPartModel downLoadNode(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public List<StorageModel> queryFjxx(MultiPartModel multiPartModel) {
        List list = JSONArray.parseArray((String)"[{\"name\":\"\u62b5\u62bc\u5408\u540c\",\"path\":\"\",\"id\":\"1\",\"fileType\":\"0\",\"children\":[{\"name\":\"lygdyht.png\",\"path\":\"D://json2json//orcTransModel//lygdyht.png\",\"id\":\"4\",\"fileType\":\"2\",\"children\":null}]},{\"name\":\"\u7533\u8bf7\u4e66\",\"path\":\"\",\"id\":\"2\",\"fileType\":\"0\",\"children\":[{\"name\":\"lygdysqs.png\",\"path\":\"D://json2json//orcTransModel//lygdysqs.png\",\"id\":\"5\",\"fileType\":\"2\",\"children\":null}]},{\"name\":\"\u8eab\u4efd\u8bc1\",\"path\":\"\",\"id\":\"3\",\"fileType\":\"0\",\"children\":[{\"name\":\"\u8eab\u4efd\u8bc1-3.jpg\",\"path\":\"D://json2json//orcTransModel//\u8eab\u4efd\u8bc1-3.jpg\",\"id\":\"6\",\"fileType\":\"2\",\"children\":null}]}]", StorageModel.class);
        return list;
    }

    @Override
    public void showFile(MultiPartModel multiPartModel, HttpServletResponse httpServletResponse) {
        List<StorageModel> list = JSONArray.parseArray((String)"[{\"name\":\"\u62b5\u62bc\u5408\u540c\",\"path\":\"\",\"id\":\"1\",\"fileType\":\"0\",\"children\":[{\"name\":\"lygdyht.png\",\"path\":\"D://json2json//orcTransModel//lygdyht.png\",\"id\":\"4\",\"fileType\":\"2\",\"children\":null}]},{\"name\":\"\u7533\u8bf7\u4e66\",\"path\":\"\",\"id\":\"2\",\"fileType\":\"0\",\"children\":[{\"name\":\"lygdysqs.png\",\"path\":\"D://json2json//orcTransModel//lygdysqs.png\",\"id\":\"5\",\"fileType\":\"2\",\"children\":null}]},{\"name\":\"\u8eab\u4efd\u8bc1\",\"path\":\"\",\"id\":\"3\",\"fileType\":\"0\",\"children\":[{\"name\":\"\u8eab\u4efd\u8bc1-3.jpg\",\"path\":\"D://json2json//orcTransModel//\u8eab\u4efd\u8bc1-3.jpg\",\"id\":\"6\",\"fileType\":\"2\",\"children\":null}]}]", StorageModel.class);
        list = this.filterStorageModelList(list);
        boolean hasFile = false;
        if (CollectionUtils.isNotEmpty(list)) {
            for (StorageModel storageModel : list) {
                String path;
                File file;
                if (!storageModel.getId().equals(multiPartModel.getCurrentNodeId()) || !(file = new File(path = storageModel.getPath())).exists()) continue;
                this.fileOutput(path, storageModel, httpServletResponse);
                hasFile = true;
                break;
            }
        }
        if (!hasFile) {
            this.serviceFactory.getStorageService().showFile(multiPartModel, httpServletResponse);
        }
    }

    private List<StorageModel> filterStorageModelList(List<StorageModel> modelList) {
        ArrayList files = Lists.newArrayList();
        int folder = FileTypeEnum.FOLDER.getType();
        if (CollectionUtils.isNotEmpty(modelList)) {
            for (StorageModel storageModel : modelList) {
                if (storageModel.getFileType().getType() == folder && CollectionUtils.isNotEmpty(storageModel.getChildren())) {
                    files.addAll(this.filterStorageModelList(storageModel.getChildren()));
                    continue;
                }
                files.add(storageModel);
            }
        }
        return files;
    }

    private void fileOutput(String path, StorageModel storageModel, HttpServletResponse httpServletResponse) {
        File file = new File(path);
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(path);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            httpServletResponse.setContentType(contentType);
        } else {
            httpServletResponse.setContentType("image/jpeg;image/png;");
        }
        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(file);){
            String filename = URLEncoder.encode(storageModel.getName(), "UTF-8");
            httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + filename);
            byte[] buffer = new byte[1024];
            int i = -1;
            while ((i = ((InputStream)fileInputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, i);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

