/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.exception.PzxException;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.service.storage.domain.bo.hlwweb.HlwWebFjxxUploadBo;
import cn.gtmap.ai.core.service.storage.domain.bo.hlwweb.HlwWebFjxxUploadDto;
import cn.gtmap.ai.core.service.token.application.AiXtJkglModelService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.domian.model.hlwweb.HlwWebBaseResponseDto;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="hlwwebStorageServiceImpl")
public class HlwWebStorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(HlwWebStorageServiceImpl.class);
    @Autowired
    private ComponentConstants componentConstants;
    @Autowired
    private AiXtJkglModelService aiXtJkglModelService;
    @Autowired
    private HttpUtil httpUtil;
    private static final String FJXX_UPLOAD_JKGJZ = "hlwweb.fjxxUpload.url";

    @Override
    public StorageModel uploadFile(MultiPartModel multiPartModel) {
        StorageModel storageModel = new StorageModel();
        String downUrl = multiPartModel.getFileUrl();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        long start = Calendar.getInstance().getTime().getTime();
        if (StringUtils.isNotBlank((CharSequence)downUrl)) {
            HttpGet httpGet = new HttpGet(downUrl);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                 InputStream in = response.getEntity().getContent();
                 ByteArrayOutputStream os = new ByteArrayOutputStream();){
                HlwWebBaseResponseDto result;
                JkglQuery jkglQuery = new JkglQuery();
                jkglQuery.setJkgjz(FJXX_UPLOAD_JKGJZ);
                jkglQuery.setQydm(this.componentConstants.getQydm());
                JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
                    throw new PzxException("\u65b0\u4e00\u7a97\u6587\u4ef6\u4e0a\u4f20: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
                }
                HlwWebFjxxUploadBo hlwWebFjxxUploadBo = new HlwWebFjxxUploadBo();
                hlwWebFjxxUploadBo.setFileName(multiPartModel.getOriginalFilename());
                hlwWebFjxxUploadBo.setFjlx(multiPartModel.getTag());
                hlwWebFjxxUploadBo.setWwslbh(multiPartModel.getAppId());
                hlwWebFjxxUploadBo.setFileType(FilenameUtils.getExtension((String)multiPartModel.getOriginalFilename()));
                HashMap param = Maps.newHashMap();
                param.put("data", JSON.toJSONString((Object)hlwWebFjxxUploadBo));
                HashMap headers = Maps.newHashMap();
                headers.put("token", jkglModel.getToken());
                IOUtils.copy((InputStream)in, (OutputStream)os);
                String responseMsg = HttpUtil.sendPostFileRequest(jkglModel.getJkdz(), param, "file", os.toByteArray(), multiPartModel.getOriginalFilename(), headers);
                if (JSONValidator.from((String)responseMsg).validate() && Objects.nonNull(result = (HlwWebBaseResponseDto)JSON.parseObject((String)responseMsg, (TypeReference)new TypeReference<HlwWebBaseResponseDto<HlwWebFjxxUploadDto>>(){}, (Feature[])new Feature[0])) && result.isSuccess() && Objects.nonNull(result.getData())) {
                    storageModel.setId(((HlwWebFjxxUploadDto)result.getData()).getFjid());
                }
            }
            catch (Exception e) {
                log.error("uploadFile \u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
        } else {
            try (ByteArrayInputStream in = new ByteArrayInputStream(multiPartModel.getData());
                 ByteArrayOutputStream os = new ByteArrayOutputStream();){
                HlwWebBaseResponseDto result;
                JkglQuery jkglQuery = new JkglQuery();
                jkglQuery.setJkgjz(FJXX_UPLOAD_JKGJZ);
                jkglQuery.setQydm(this.componentConstants.getQydm());
                JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
                    throw new PzxException("\u65b0\u4e00\u7a97\u6587\u4ef6\u4e0a\u4f20: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
                }
                HlwWebFjxxUploadBo hlwWebFjxxUploadBo = new HlwWebFjxxUploadBo();
                hlwWebFjxxUploadBo.setFileName(multiPartModel.getOriginalFilename());
                hlwWebFjxxUploadBo.setFjlx(multiPartModel.getTag());
                hlwWebFjxxUploadBo.setWwslbh(multiPartModel.getAppId());
                hlwWebFjxxUploadBo.setFileType(FilenameUtils.getExtension((String)multiPartModel.getOriginalFilename()));
                HashMap param = Maps.newHashMap();
                param.put("data", JSON.toJSONString((Object)hlwWebFjxxUploadBo));
                HashMap headers = Maps.newHashMap();
                headers.put("token", jkglModel.getToken());
                IOUtils.copy((InputStream)in, (OutputStream)os);
                String responseMsg = HttpUtil.sendPostFileRequest(jkglModel.getJkdz(), param, "file", os.toByteArray(), multiPartModel.getOriginalFilename(), headers);
                if (JSONValidator.from((String)responseMsg).validate() && Objects.nonNull(result = (HlwWebBaseResponseDto)JSON.parseObject((String)responseMsg, (TypeReference)new TypeReference<HlwWebBaseResponseDto<HlwWebFjxxUploadDto>>(){}, (Feature[])new Feature[0])) && result.isSuccess() && Objects.nonNull(result.getData())) {
                    storageModel.setId(((HlwWebFjxxUploadDto)result.getData()).getFjid());
                }
            }
            catch (Exception e) {
                log.error("uploadFile \u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        long end = Calendar.getInstance().getTime().getTime();
        log.info("\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3 {} \u8017\u65f6 {} ms", (Object)JSON.toJSONString((Object)storageModel), (Object)(end - start));
        return storageModel;
    }

    @Override
    public StorageModel createFolder(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public MultiPartModel downLoadNode(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public List<StorageModel> queryFjxx(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public void showFile(MultiPartModel multiPartModel, HttpServletResponse httpServletResponse) {
    }
}

