/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.auth.application.impl;

import cn.gtmap.ai.core.base.AuthTokenDto;
import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.exception.PzxException;
import cn.gtmap.ai.core.exception.TokenException;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.application.convert.UserInfoConverter;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginTokenDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoRoleDto;
import cn.gtmap.ai.core.service.token.application.impl.AiXtJkglModelServiceImpl;
import cn.gtmap.ai.core.service.token.domian.model.AiXtDsfxtjr;
import cn.gtmap.ai.core.service.token.domian.model.AiXtJkgl;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.domian.model.hlwweb.HlwWebBaseResponseDto;
import cn.gtmap.ai.core.service.token.domian.model.hlwweb.login.HlwWebLoginBO;
import cn.gtmap.ai.core.service.token.domian.repository.AiXtDsfxtjrRepository;
import cn.gtmap.ai.core.service.token.domian.repository.AiXtJkglRepository;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.service.user.domain.model.hlwweb.HlwWebUserInfoByUseridBO;
import cn.gtmap.ai.core.service.user.domain.model.hlwweb.HlwWebUserInfoDto;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import cn.gtmap.ai.core.utils.string.StringUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.estateplat.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="hlwwebAuthServiceImpl")
public class HlwWebAuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(HlwWebAuthServiceImpl.class);
    @Autowired
    private ComponentConstants componentConstants;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AiXtJkglModelServiceImpl aiXtJkglModelService;
    @Autowired
    private AiXtJkglRepository aiXtJkglRepository;
    @Autowired
    private AiXtDsfxtjrRepository aiXtDsfxtjrRepository;
    @Autowired
    private HttpUtil httpUtil;
    private static final String ENCRYPT_JKGJZ = "hlwweb.encrypt.url";
    private static final String LOGIN_JKGJZ = "hlwweb.login.url";
    private static final String LOGOUT_JKGJZ = "hlwweb.logout.url";
    private static final String USERINFO_JKGJZ = "hlwweb.userinfo.url";
    private static final String USERINFO_USERID_JKGJZ = "hlwweb.userinfobyuserid.url";

    @Override
    public LoginResultDto login(LoginUserBaseDto loginUserBaseDto) {
        LoginResultDto loginResultDto = new LoginResultDto();
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getLxdh(), loginUserBaseDto.getPassword()})) {
            loginResultDto.setError(ErrorEnum.PARAM_NULL);
            return loginResultDto;
        }
        JkglQuery tokenJkglQuery = new JkglQuery();
        tokenJkglQuery.setJkgjz(LOGIN_JKGJZ);
        tokenJkglQuery.setQydm(this.componentConstants.getQydm());
        AiXtJkgl aiXtJkglToken = this.aiXtJkglModelService.replaceJkglProperties(tokenJkglQuery);
        if (Objects.nonNull(aiXtJkglToken)) {
            tokenJkglQuery.setJkgjz(null);
            tokenJkglQuery.setYydm(aiXtJkglToken.getYydm());
            tokenJkglQuery.setQydm(aiXtJkglToken.getQydm());
            AiXtDsfxtjr aiXtDsfxtjr = this.aiXtDsfxtjrRepository.getAiXtDsfxtjrByJkglQuery(tokenJkglQuery);
            if (Objects.nonNull(aiXtDsfxtjr) && JSONValidator.from((String)aiXtDsfxtjr.getJrcs()).validate() && (loginResultDto = this.getToken(aiXtJkglToken, aiXtDsfxtjr, loginUserBaseDto)).isSuccesss() && Objects.isNull(loginResultDto.getUserInfoDto())) {
                this.getUserInfo(loginResultDto.getLoginItem(), loginResultDto.getToken(), loginResultDto);
            }
        }
        return loginResultDto;
    }

    @Override
    public LoginResultDto login(LoginTokenDto loginTokenDto) {
        return null;
    }

    @Override
    public IError logout() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SUCCESS;
        }
        String token = request.getParameter("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.redisUtils.getStringValue(UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.redisUtils.deleteKey(UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId()));
            String userInfo = this.redisUtils.getStringValue(UserRedisContants.getUserinfoByTokenPrefixRedisKey(token));
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                this.redisUtils.deleteKey(UserRedisContants.getUserinfoByTokenPrefixRedisKey(token));
                LoginResultDto loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class);
                if (Objects.nonNull(loginResultDto) && StringUtils.isNotBlank((CharSequence)loginResultDto.getLoginItem())) {
                    this.redisUtils.deleteKey(UserRedisContants.getApiauthAccesstokenByloginnamePrefixRedisKey(loginResultDto.getLoginItem(), this.componentConstants.getQydm()));
                    if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                        this.redisUtils.deleteKey(UserRedisContants.getRestauthOrginalTokenByClientTokenPrefixRedisKey(loginResultDto.getToken()));
                        this.redisUtils.deleteKey(UserRedisContants.getRestauthClientByTokenPrefixRedisKey(loginResultDto.getToken()));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)token)) {
                    JkglQuery jkglQuery = new JkglQuery();
                    jkglQuery.setJkgjz(LOGOUT_JKGJZ);
                    jkglQuery.setQydm(this.componentConstants.getQydm());
                    JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                    if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
                        HashMap headers = Maps.newHashMap();
                        headers.put("token", token);
                        String result = HttpUtil.postRequest(jkglModel.getJkdz(), null, null, headers);
                        log.info("hlwweb.logout.url {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), jkglModel.getJkdz(), result});
                        return ErrorEnum.SUCCESS;
                    }
                    return ErrorEnum.PZX_NOT_EXISTS;
                }
            }
            return ErrorEnum.SUCCESS;
        }
        return ErrorEnum.UN_AUTHORIZED;
    }

    public LoginResultDto getToken(AiXtJkgl aiXtJkglToken, AiXtDsfxtjr aiXtDsfxtjr, LoginUserBaseDto loginUserBaseDto) {
        if (Objects.isNull(aiXtJkglToken) || StringUtils.isBlank((CharSequence)aiXtJkglToken.getJkdz())) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u63a5\u53e3\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String accessToken = "";
        JSONObject jrqtcs = JSONObject.parseObject((String)aiXtDsfxtjr.getJrcs());
        LoginUserBaseDto newLoginUserBaseDto = this.processLoginParam(loginUserBaseDto, jrqtcs);
        String loginName = newLoginUserBaseDto.getLxdh();
        String encodeValue = newLoginUserBaseDto.getPassword();
        LoginResultDto loginResultDto = new LoginResultDto();
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName, encodeValue})) {
            loginResultDto.setError(ErrorEnum.PARAM_NULL);
            return loginResultDto;
        }
        String redisKey = UserRedisContants.getApiauthAccesstokenByloginnamePrefixRedisKey(loginName, aiXtJkglToken.getQydm());
        String token = this.redisUtils.getStringValue(redisKey);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            log.info("{},\u83b7\u53d6\u65f6\u95f4:{},\u672a\u8fc7\u671f", (Object)redisKey, (Object)DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT));
            this.getUserInfo(loginName, token, loginResultDto);
            if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                accessToken = token;
            }
        }
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)encodeValue)) {
            this.getToken(aiXtJkglToken.getJkdz(), loginName, encodeValue, loginResultDto);
            accessToken = loginResultDto.getToken();
            if (loginResultDto.isSuccesss() && StringUtils.isNotBlank((CharSequence)accessToken)) {
                loginResultDto.setExpiresIn(5400L);
                loginResultDto.setToken(accessToken);
                loginResultDto.setError(ErrorEnum.SUCCESS);
                loginResultDto.setLoginItem(loginName);
                this.redisUtils.addStringValue(redisKey, accessToken, loginResultDto.getExpiresIn());
            }
        }
        return loginResultDto;
    }

    private void getToken(String tokenUrl, String loginName, String encodeValue, LoginResultDto loginResultDto) {
        String accessToken = "";
        HlwWebLoginBO hlwWebLoginBO = new HlwWebLoginBO();
        hlwWebLoginBO.setLoginName(loginName);
        hlwWebLoginBO.setLoginPwd(encodeValue);
        ParameterizedTypeReference<HlwWebBaseResponseDto<HlwWebUserInfoDto>> typeRef = new ParameterizedTypeReference<HlwWebBaseResponseDto<HlwWebUserInfoDto>>(){};
        final HlwWebBaseResponseDto<HlwWebUserInfoDto> result = this.httpUtil.getPostData(JSON.toJSONString((Object)hlwWebLoginBO), tokenUrl, typeRef, LOGIN_JKGJZ, UUIDGenerator.generate18());
        log.info("hlwweb.token.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), tokenUrl, result});
        if (Objects.nonNull(result)) {
            if (result.isSuccess()) {
                accessToken = result.getToken();
                loginResultDto.setToken(accessToken);
                loginResultDto.setError(ErrorEnum.SUCCESS);
            } else {
                loginResultDto.setError(new IError(){

                    @Override
                    public String getCode() {
                        return result.getCode();
                    }

                    @Override
                    public String getMsg() {
                        return result.getMsg();
                    }

                    @Override
                    public boolean isSuccesss() {
                        return false;
                    }
                });
            }
        }
    }

    private LoginUserBaseDto processLoginParam(LoginUserBaseDto loginUserBaseDto, JSONObject jrqtcs) {
        String loginPwd;
        String loginName;
        LoginUserBaseDto newLoginUserBaseDto = new LoginUserBaseDto();
        String encodeValue = null;
        String k = Sm2lib.decode(CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"k")));
        if (Objects.nonNull(loginUserBaseDto) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getLxdh(), loginUserBaseDto.getPassword()})) {
            loginName = loginUserBaseDto.getLxdh();
            loginPwd = loginUserBaseDto.getPassword();
        } else if (Objects.nonNull(loginUserBaseDto) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getYhm(), loginUserBaseDto.getMm()})) {
            loginName = loginUserBaseDto.getYhm();
            loginPwd = loginUserBaseDto.getMm();
        } else {
            loginName = Sm2lib.decode(CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"loginName")));
            loginPwd = Sm2lib.decode(CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"loginPwd")));
        }
        encodeValue = Sm2lib.encode(loginPwd, k);
        newLoginUserBaseDto.setLxdh(loginName);
        newLoginUserBaseDto.setPassword(encodeValue);
        return newLoginUserBaseDto;
    }

    public void getUserInfo(String loginItem, String token, LoginResultDto loginResultDto) {
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setJkgjz(USERINFO_JKGJZ);
        jkglQuery.setQydm(this.componentConstants.getQydm());
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (Objects.nonNull(jkglModel) && StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
            if (StringUtils.isNotBlank((CharSequence)token)) {
                token = token.replace(" ", "+");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("token", token);
            String queryUrl = jkglModel.getJkdz();
            ParameterizedTypeReference<HlwWebBaseResponseDto<HlwWebUserInfoDto>> typeRef = new ParameterizedTypeReference<HlwWebBaseResponseDto<HlwWebUserInfoDto>>(){};
            HlwWebBaseResponseDto<HlwWebUserInfoDto> result = this.httpUtil.getPostData("{}", queryUrl, typeRef, jkglModel.getJkgjz(), UUIDGenerator.generate18(), headers);
            log.info("hlwweb.userinfo.key {} httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, JSON.toJSONString(result)});
            if (Objects.nonNull(result)) {
                if (!result.isSuccess()) {
                    throw new TokenException(result.getCode(), result.getMsg());
                }
                HlwWebUserInfoDto hlwWebUserInfoDto = result.getData();
                if (Objects.isNull(hlwWebUserInfoDto)) {
                    log.info("getUserInfo() - hlwWebUserInfoDto \u503c\u4e3a\u7a7a");
                    return;
                }
                if (StringUtils.isBlank((CharSequence)loginItem)) {
                    loginItem = hlwWebUserInfoDto.getLxDh();
                }
                if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                    token = StringUtil.crossCombine(token, loginResultDto.getClientId());
                }
                this.transToLoginResultDto(loginResultDto, hlwWebUserInfoDto, token);
                loginResultDto.setLoginItem(loginItem);
                String redisKey = UserRedisContants.getUserinfoByTokenPrefixRedisKey(token);
                this.redisUtils.addStringValue(redisKey, JSON.toJSONString((Object)loginResultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto.getExpiresIn());
            } else {
                loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
        }
    }

    @Override
    public UserInfoDto getUserInfoByToken(String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            token = token.replace(" ", "+");
        }
        LoginResultDto loginResultDto = new LoginResultDto();
        this.getUserInfo(null, token, loginResultDto);
        if (loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        String orinalToken = this.redisUtils.getStringValue(UserRedisContants.getRestauthOrginalTokenByClientTokenPrefixRedisKey(token));
        this.getUserInfo(null, orinalToken, loginResultDto);
        if (loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        return null;
    }

    @Override
    public IError checkLogin(LoginUserBaseDto loginUserBaseDto) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SERVICE_ERROR;
        }
        String redisKey = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
        String token = this.redisUtils.getStringValue(redisKey);
        return StringUtils.isNotBlank((CharSequence)token) ? ErrorEnum.SUCCESS : ErrorEnum.SERVICE_ERROR;
    }

    @Override
    public AuthTokenDto generateToken(LoginUserBaseDto loginUserBaseDto) {
        log.info("**********LoginUserBaseDto:{}***********", (Object)JSON.toJSONString((Object)loginUserBaseDto));
        AuthTokenDto authTokenDto = new AuthTokenDto();
        LoginResultDto loginResultDto = new LoginResultDto();
        JkglQuery tokenJkglQuery = new JkglQuery();
        tokenJkglQuery.setJkgjz(LOGIN_JKGJZ);
        tokenJkglQuery.setQydm(this.componentConstants.getQydm());
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(tokenJkglQuery);
        if (Objects.isNull(jkglModel)) {
            return authTokenDto;
        }
        String accessToken = "";
        if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz()) && Objects.nonNull(loginUserBaseDto)) {
            String encodeValue;
            JSONObject jrqtcs = jkglModel.getJrcs();
            LoginUserBaseDto newLoginUserBaseDto = this.processLoginParam(loginUserBaseDto, jrqtcs);
            String loginName = newLoginUserBaseDto.getLxdh();
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName, encodeValue = newLoginUserBaseDto.getPassword()})) {
                throw new TokenException(ErrorEnum.PARAM_NULL);
            }
            boolean differentClient = StringUtils.isNotBlank((CharSequence)loginUserBaseDto.getClientId());
            loginResultDto.setClientId(loginUserBaseDto.getClientId());
            String redisKey = UserRedisContants.getRestauthRestTokenByLoginnamePrefixRedisKey(loginUserBaseDto.getClientId(), loginName, jkglModel.getQydm());
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                this.getToken(jkglModel.getJkdz(), loginName, encodeValue, loginResultDto);
                String orginaltoken = accessToken = loginResultDto.getToken();
                if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                    loginResultDto.setExpiresIn(5400L);
                    loginResultDto.setToken(accessToken);
                    loginResultDto.setError(ErrorEnum.SUCCESS);
                    this.getUserInfo(loginName, accessToken, loginResultDto);
                    if (differentClient) {
                        accessToken = StringUtil.crossCombine(accessToken, loginUserBaseDto.getClientId());
                    }
                    authTokenDto.setToken(accessToken);
                    authTokenDto.setExpireIn(5400L);
                    this.redisUtils.addStringValue(redisKey, accessToken, loginResultDto.getExpiresIn());
                    this.redisUtils.addStringValue(UserRedisContants.getLoginNameByTokenPrefixRedisKey(accessToken), loginName, loginResultDto.getExpiresIn());
                    if (differentClient) {
                        this.redisUtils.addStringValue(UserRedisContants.getRestauthOrginalTokenByClientTokenPrefixRedisKey(accessToken), orginaltoken, loginResultDto.getExpiresIn());
                        this.redisUtils.addStringValue(UserRedisContants.getRestauthClientByTokenPrefixRedisKey(accessToken), loginUserBaseDto.getClientId(), loginResultDto.getExpiresIn());
                    }
                }
            }
        }
        return authTokenDto;
    }

    @Override
    public IError checkToken(String token) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SERVICE_ERROR;
        }
        String redisKey = UserRedisContants.getLoginNameByTokenPrefixRedisKey(token);
        return StringUtils.isNotBlank((CharSequence)this.redisUtils.getStringValue(redisKey)) ? ErrorEnum.SUCCESS : ErrorEnum.SERVICE_ERROR;
    }

    @Override
    public UserInfoDto getUserInfoByUserId(String userId) {
        LoginResultDto loginResultDto;
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        String userInfo = this.redisUtils.getStringValue(UserRedisContants.getRestauthUserinfoByClientidPrefixRedisKey(userId));
        if (StringUtils.isNotBlank((CharSequence)userInfo) && Objects.nonNull(loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class)) && loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setJkgjz(USERINFO_USERID_JKGJZ);
        jkglQuery.setQydm(this.componentConstants.getQydm());
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
            HlwWebUserInfoByUseridBO hlwWebUserInfoByUseridBO = new HlwWebUserInfoByUseridBO();
            hlwWebUserInfoByUseridBO.setUserGuid(userId);
            ParameterizedTypeReference<HlwWebBaseResponseDto<HlwWebUserInfoDto>> typeRef = new ParameterizedTypeReference<HlwWebBaseResponseDto<HlwWebUserInfoDto>>(){};
            HttpHeaders headers = new HttpHeaders();
            headers.add("token", jkglModel.getToken());
            HlwWebBaseResponseDto<HlwWebUserInfoDto> hlwWebBaseResponseDto = this.httpUtil.getPostData(JSON.toJSONString((Object)hlwWebUserInfoByUseridBO), jkglModel.getJkdz(), typeRef, jkglModel.getJkgjz(), UUIDGenerator.generate18(), headers);
            if (Objects.isNull(hlwWebBaseResponseDto) || !hlwWebBaseResponseDto.isSuccess()) {
                throw new BizException(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
            HlwWebUserInfoDto hlwWebUserInfoDto = hlwWebBaseResponseDto.getData();
            String token = hlwWebBaseResponseDto.getToken();
            if (Objects.isNull(hlwWebUserInfoDto)) {
                log.info("getUserInfoByUserId() - hlwWebUserInfoDto \u503c\u4e3a\u7a7a");
                throw new BizException(ErrorEnum.NOT_FOUND);
            }
            LoginResultDto loginResultDto2 = new LoginResultDto();
            this.transToLoginResultDto(loginResultDto2, hlwWebUserInfoDto, token);
            this.redisUtils.addStringValue(UserRedisContants.getRestauthUserinfoByClientidPrefixRedisKey(userId), JSON.toJSONString((Object)loginResultDto2, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto2.getExpiresIn());
            return loginResultDto2.getUserInfoDto();
        }
        throw new PzxException("\u901a\u8fc7userId\u83b7\u53d6\u7528\u6237\u4fe1\u606f: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
    }

    private void transToLoginResultDto(LoginResultDto loginResultDto, HlwWebUserInfoDto hlwWebUserInfoDto, String token) {
        UserInfoDto userInfoDto = UserInfoConverter.INSTANCE.hlwwebUserToUserInfoDto(hlwWebUserInfoDto);
        userInfoDto.setDsfyhInfo(JSON.toJSONString((Object)hlwWebUserInfoDto));
        userInfoDto.setQydm("320700");
        DesensitizedUtil.desensitizeObj(userInfoDto);
        ArrayList roleDtoList = Lists.newArrayList();
        userInfoDto.setRoleList(roleDtoList);
        UserInfoRoleDto userInfoRoleDto = new UserInfoRoleDto();
        userInfoRoleDto.setRoleId(String.valueOf(hlwWebUserInfoDto.getRoleId()));
        userInfoRoleDto.setRoleName(hlwWebUserInfoDto.getRoleName());
        loginResultDto.setUserInfoDto(userInfoDto);
        loginResultDto.setToken(token);
        loginResultDto.setError(ErrorEnum.SUCCESS);
        loginResultDto.setExpiresIn(5400L);
    }
}

