/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.fjstorage;

import cn.gtmap.ai.core.annotation.auth.AuthCheck;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/fj/v1"})
public class FjStorageController {
    private static final Logger log = LoggerFactory.getLogger(FjStorageController.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ServiceFactory serviceFactory;

    @ResponseBody
    @PostMapping(value={"/queryFjxxList"})
    @AuthCheck
    public ReturnResult queryFjxxList(@RequestBody MultiPartModel multiPartModel) {
        StorageService storageService = this.serviceFactory.getStorageService();
        return ReturnResult.success(storageService.queryFjxx(multiPartModel));
    }

    @ResponseBody
    @GetMapping(value={"/showFile"})
    @AuthCheck
    public void showFile(String currentNodeId, HttpServletResponse httpServletResponse) {
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setCurrentNodeId(currentNodeId);
        StorageService storageService = this.serviceFactory.getStorageService();
        storageService.showFile(multiPartModel, httpServletResponse);
    }

    @ResponseBody
    @GetMapping(value={"/showFile/{tickect}"})
    public void showFileRest(@PathVariable(value="tickect") String tickect, HttpServletResponse httpServletResponse) {
        String currentNodeId = this.redisUtils.getStringValue("rest:fjid:" + EncryptUtil.encryptStr(tickect, EncryptTypeEnum.MD5Salt));
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setCurrentNodeId(currentNodeId);
        StorageService storageService = this.serviceFactory.getStorageService();
        storageService.showFile(multiPartModel, httpServletResponse);
    }
}

