/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.common;

import cn.gtmap.ai.core.annotation.auth.AuthCheck;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.setting.application.AiXtZdService;
import cn.gtmap.ai.core.service.setting.query.AiXtZdQuery;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/common/v1"})
public class CommonController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Value(value="${letter.yzm.use:false}")
    private boolean letterYzmUse;
    @Autowired
    private DefaultKaptcha captchaProducer;
    @Autowired
    private AiXtZdService aiXtZdService;
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ComponentConstants componentConstants;
    @Autowired
    private Environment environment;

    @GetMapping(value={"/kaptcha"})
    public void defaultKaptcha(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        byte[] captchaOutputStream = null;
        ByteArrayOutputStream imgOutputStream = new ByteArrayOutputStream();
        try {
            String verifyCode = this.captchaProducer.createText();
            httpServletRequest.getSession().setAttribute("verifyCode", (Object)verifyCode);
            BufferedImage challenge = this.captchaProducer.createImage(verifyCode);
            ImageIO.write((RenderedImage)challenge, "jpg", imgOutputStream);
        }
        catch (IllegalArgumentException e) {
            log.error("\u9519\u8bef\u539f\u56e0:{}", (Throwable)e);
            httpServletResponse.sendError(404);
            return;
        }
        captchaOutputStream = imgOutputStream.toByteArray();
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaOutputStream);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    @ResponseBody
    @PostMapping(value={"/queryXtZdList"})
    @AuthCheck
    public ReturnResult queryXtZdList(@RequestBody AiXtZdQuery aiXtZdQuery) {
        return ReturnResult.success(this.aiXtZdService.queryXtZdList(aiXtZdQuery));
    }

    @ResponseBody
    @PostMapping(value={"/updatextcs"})
    @AuthCheck
    public ReturnResult updatextcs(@RequestBody ComponentConstants componentConstantsUpdate) {
        Field[] fields = componentConstantsUpdate.getClass().getDeclaredFields();
        if (Objects.nonNull(fields)) {
            Throwable throwable;
            String configLocation = this.environment.getProperty("spring.config.location");
            URL url = this.getClass().getClassLoader().getResource("application.properties");
            String path = url.getPath();
            if (StringUtils.isNotBlank((CharSequence)configLocation)) {
                path = path.substring(path.lastIndexOf("/app/")) + File.separator + "cfg" + File.separator + "application.properties";
            }
            log.error("updatextcs configLocation:{}", (Object)configLocation);
            log.error("updatextcs path:{}", (Object)path);
            File file = new File(path);
            List stringList = null;
            try {
                throwable = null;
                try (FileInputStream in = new FileInputStream(file);){
                    stringList = IOUtils.readLines((InputStream)in);
                    for (Field field : fields) {
                        try {
                            field.setAccessible(true);
                            Object o = field.get(componentConstantsUpdate);
                            Value v = field.getAnnotation(Value.class);
                            if (!Objects.nonNull(o) || !StringUtils.isNotBlank((CharSequence)o.toString())) continue;
                            field.set(this.componentConstants, o);
                            if (!Objects.nonNull(v) || !StringUtils.isNotBlank((CharSequence)v.value())) continue;
                            String expression = v.value();
                            if (expression.startsWith("${")) {
                                expression = expression.substring(2);
                            }
                            if (expression.contains(":")) {
                                expression = expression.substring(0, expression.indexOf(":"));
                            }
                            for (int i = 0; i < stringList.size(); ++i) {
                                if (!StringUtils.startsWith((CharSequence)((CharSequence)stringList.get(i)), (CharSequence)(expression + "="))) continue;
                                stringList.set(i, expression + "=" + o.toString());
                            }
                        }
                        catch (Exception e) {
                            log.error("updatextcs \u66f4\u65b0\u53c2\u6570 \u3010" + field.getName() + "\u3011 \u5931\u8d25 :{}", (Object)e.getMessage());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                log.error("updatextcs Exception:", (Object)e.getMessage());
            }
            try {
                throwable = null;
                try (FileWriter writer = new FileWriter(url.getPath());){
                    if (CollectionUtils.isNotEmpty((Collection)stringList)) {
                        IOUtils.writeLines((Collection)stringList, null, (Writer)writer);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ReturnResult.success();
    }

    @ResponseBody
    @PostMapping(value={"/xtcs"})
    @AuthCheck
    public ReturnResult xtcs() {
        return ReturnResult.success(this.componentConstants);
    }
}

