/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.constant;

import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class UserRedisContants {
    private static final String USERINFO_BYTOKEN_PREFIX = "login:userinfo:bytoken:";
    private static final String RESTAUTH_USERINFO_BYCLIENTID_PREFIX = "login:userinfo:byclientid:";
    private static final String APIAUTH_ACCESSTOKEN_BYLOGINNAME_PREFIX = "login:token:byloginname:";
    private static final String APIAUTHTOKEN_BYSESSION_PREFIX = "login:token:bysession:";
    private static final String LOGINNAME_BYTOKEN_PREFIX = "login:loginname:bytoken:";
    private static final String RESTAUTH_CLIENT_BYTOKEN_PREFIX = "login:restclientid:bytoken:";
    private static final String RESTAUTH_RESTTOKEN_BYLOGINNAME_PREFIX = "login:resttoken:byloginname:";
    private static final String RESTAUTH_ORGINALTOKEN_BYCLIENTTOKEN_PREFIX = "login:orginaltoken:byclienttoken:";
    private static final String LOGINYYDM_BYSESSION_PREFIX = "login:yydm:bysession";

    public static String getApiauthAccesstokenByloginnamePrefixRedisKey(String lxdh, String qydm) {
        String redisKey = APIAUTH_ACCESSTOKEN_BYLOGINNAME_PREFIX + EncryptUtil.encryptStr(lxdh, EncryptTypeEnum.MD5Salt);
        if (StringUtils.isNotBlank((CharSequence)qydm)) {
            redisKey = redisKey + "_" + qydm;
        }
        return redisKey;
    }

    public static String getRestauthUserinfoByClientidPrefixRedisKey(String clientId) {
        return RESTAUTH_USERINFO_BYCLIENTID_PREFIX + EncryptUtil.encryptStr(clientId, EncryptTypeEnum.MD5Salt);
    }

    public static String getRestauthRestTokenByLoginnamePrefixRedisKey(String clientId, String lxdh, String qydm) {
        String redisKey;
        String string = redisKey = StringUtils.isNotBlank((CharSequence)clientId) ? RESTAUTH_RESTTOKEN_BYLOGINNAME_PREFIX + EncryptUtil.encryptStr(StringUtil.crossCombine(lxdh, clientId), EncryptTypeEnum.MD5Salt) : RESTAUTH_RESTTOKEN_BYLOGINNAME_PREFIX + EncryptUtil.encryptStr(lxdh, EncryptTypeEnum.MD5Salt);
        if (StringUtils.isNotBlank((CharSequence)qydm)) {
            redisKey = redisKey + "_" + qydm;
        }
        return redisKey;
    }

    public static String getUserinfoByTokenPrefixRedisKey(String token) {
        return USERINFO_BYTOKEN_PREFIX + EncryptUtil.encryptStr(token, EncryptTypeEnum.MD5Salt);
    }

    public static String getRestauthOrginalTokenByClientTokenPrefixRedisKey(String token) {
        return RESTAUTH_ORGINALTOKEN_BYCLIENTTOKEN_PREFIX + EncryptUtil.encryptStr(token, EncryptTypeEnum.MD5Salt);
    }

    public static String getRestauthClientByTokenPrefixRedisKey(String token) {
        return RESTAUTH_CLIENT_BYTOKEN_PREFIX + EncryptUtil.encryptStr(token, EncryptTypeEnum.MD5Salt);
    }

    public static String getLoginNameByTokenPrefixRedisKey(String token) {
        return LOGINNAME_BYTOKEN_PREFIX + EncryptUtil.encryptStr(token, EncryptTypeEnum.MD5Salt);
    }

    public static String getApiauthTokenBySessionPrefixRedisKey(String sessionId) {
        return APIAUTHTOKEN_BYSESSION_PREFIX + EncryptUtil.encryptStr(sessionId, EncryptTypeEnum.MD5Salt);
    }

    public static String getApiauthYydmBySessionPrefixRedisKey(String sessionId) {
        return LOGINYYDM_BYSESSION_PREFIX + EncryptUtil.encryptStr(sessionId, EncryptTypeEnum.MD5Salt);
    }
}

