/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.advice;

import cn.gtmap.ai.core.base.RestReturnResult;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.zdzh.ReturnResultItemZdzhUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class CustomResponseBodyAdviceAdapter
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomResponseBodyAdviceAdapter.class);
    private static final Logger logger = LoggerFactory.getLogger(CustomResponseBodyAdviceAdapter.class);
    @Autowired
    private ReturnResultItemZdzhUtil zdzhUtil;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Object result;
        Object data;
        if (Objects.isNull(body)) {
            throw new BizException(ErrorEnum.PARAM_NULL);
        }
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Object allmessage = httpServletRequest.getAttribute("allmessage");
        try {
            data = null;
            if (body instanceof ReturnResult && (Objects.isNull(allmessage) || !((Boolean)allmessage).booleanValue())) {
                result = (ReturnResult)body;
                if (!((ReturnResult)result).isSuccess() || Objects.isNull(((ReturnResult)result).getData())) {
                    return result;
                }
                data = ((ReturnResult)result).getData();
            } else if (body instanceof RestReturnResult && (Objects.isNull(allmessage) || !((Boolean)allmessage).booleanValue())) {
                result = (RestReturnResult)body;
                if (!((RestReturnResult)result).isSuccess() || Objects.isNull(((RestReturnResult)result).getData())) {
                    return result;
                }
                data = ((RestReturnResult)result).getData();
            }
            if (Objects.nonNull(data)) {
                DesensitizedUtil.desensitizeResult(data);
            }
        }
        catch (Exception e) {
            logger.error("CustomResponseBodyAdviceAdapter.beforeBodyWrite \u8131\u654f\u65b9\u6cd5\u5f02\u5e38\u4fe1\u606f\uff1a", (Object)e.getMessage());
        }
        try {
            data = null;
            if (body instanceof ReturnResult) {
                result = (ReturnResult)body;
                if (!((ReturnResult)result).isSuccess() || Objects.isNull(((ReturnResult)result).getData())) {
                    return result;
                }
                data = ((ReturnResult)result).getData();
            } else if (body instanceof RestReturnResult) {
                result = (RestReturnResult)body;
                if (!((RestReturnResult)result).isSuccess() || Objects.isNull(((RestReturnResult)result).getData())) {
                    return result;
                }
                data = ((RestReturnResult)result).getData();
            }
            if (Objects.nonNull(data)) {
                this.zdzhUtil.zdzhResult(data);
            }
        }
        catch (Exception e) {
            logger.error("CustomResponseBodyAdviceAdapter.beforeBodyWrite \u5b57\u5178\u5bf9\u7167\u65b9\u6cd5\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return body;
    }
}

