/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.time;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final FastDateFormat DATETIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String systemDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        return sdf.format(new Date());
    }

    public static String getDateFormat(Date date, String dateFormat) {
        String nYr = "";
        if (!Objects.isNull(date)) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            nYr = sdf.format(date);
        }
        return nYr;
    }

    public static Date getCurHMSDate() {
        Date date = null;
        GregorianCalendar today = new GregorianCalendar();
        String str = DATETIME_FORMAT.format(today.getTime());
        try {
            date = DATETIME_FORMAT.parse(str);
        }
        catch (Exception e) {
            logger.info("\u65e5\u671f\u5de5\u5177\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
            return null;
        }
        return date;
    }

    public static String today() {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(new Date());
    }

    public static Date stringToDate(String sj) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        Date date = null;
        try {
            date = sdf.parse(sj);
        }
        catch (ParseException e) {
            logger.error("\u5b57\u7b26\u4e32\u8f6cDate\u51fa\u9519", (Throwable)e);
        }
        return date;
    }

    public static String getCurrentTimeMillisId() {
        String id = "";
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        id = simpleDateFormat.format(date);
        return id;
    }

    public static String getNextDate(String nowstring) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
        Date nowdate = null;
        try {
            nowdate = sdf.parse(nowstring);
        }
        catch (ParseException e) {
            logger.error("\u83b7\u53d6\u4e0b\u4e00\u5929\u51fa\u9519", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(nowdate);
        calendar.add(5, 1);
        Date date = calendar.getTime();
        String time = sdf.format(date);
        return time;
    }

    public static Date systemDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        String time = sdf.format(new Date());
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            logger.error("\u83b7\u53d6\u7cfb\u7edf\u65f6\u95f4\u51fa\u9519", (Throwable)e);
        }
        return date;
    }

    public static Date bankString(String bankString) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        String time = bankString.substring(0, 4) + '-' + bankString.substring(4, 6) + '-' + bankString.substring(6, 8) + ' ' + bankString.substring(8, 10) + ':' + bankString.substring(10, 12) + ':' + bankString.substring(12, 14);
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            logger.info("\u65e5\u671f\u5de5\u5177\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        return date;
    }

    public static String getPreviousDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
        String time = sdf.format(date);
        return time;
    }

    public static String getNowDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
        String time = sdf.format(date);
        return time;
    }

    public static FastDateFormat getFastDateFormat(String type) {
        return FastDateFormat.getInstance((String)type);
    }

    public static String dateToString(Date date, String type) {
        SimpleDateFormat sdf = new SimpleDateFormat(type);
        String time = sdf.format(date);
        return time;
    }

    public static Date stringToDate(String dateStr, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            logger.info("\u65e5\u671f\u5de5\u5177\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        return date;
    }

    public static Date addDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date changeSqlDate(Date date, String formt) {
        String s = DateUtils.dateToString(date, formt);
        return DateUtils.stringToDate(s, formt);
    }

    public static Date timeMinusDay(Date time, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(5, calendar.get(5) - day);
        return calendar.getTime();
    }

    public static Date longToDate(long dateStr, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        Date date = null;
        try {
            date = new Date(dateStr);
            sdf.format(date);
        }
        catch (Exception e) {
            logger.info("\u65e5\u671f\u5de5\u5177\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        return date;
    }

    public static long countDateDisparity(Date afterDate, Date beforeDate) {
        long result = 0L;
        long after = afterDate.getTime() / 1000L;
        long before = beforeDate.getTime() / 1000L;
        result = after - before;
        return result;
    }

    public static boolean compareDateDisparity(Date afterDate, Date beforeDate, long disparityValue) {
        try {
            long result = 0L;
            long after = afterDate.getTime() / 1000L;
            long before = beforeDate.getTime() / 1000L;
            result = after - before - disparityValue;
            if (result > 0L) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Map getYearMonthDay(Date date) {
        HashMap map = Maps.newHashMap();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        Integer day = cal.get(5);
        map.put("year", String.valueOf(year));
        map.put("month", String.valueOf(month));
        map.put("date", String.valueOf(day));
        return map;
    }

    public static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD);
        String result = format.format(today);
        return result;
    }

    public static String addDay(int day, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, day);
        Date newDay = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        String result = simpleDateFormat.format(newDay);
        return result;
    }

    public static boolean startBiggerEqualThanEnd(String start, String end) {
        SimpleDateFormat sdfHm = new SimpleDateFormat("HH:mm");
        long day = 0L;
        try {
            Date date = sdfHm.parse(start);
            Date myDate = sdfHm.parse(end);
            day = (date.getTime() - myDate.getTime()) / 60000L;
        }
        catch (Exception e) {
            return false;
        }
        return day >= 0L;
    }

    public static String formateToStrHMDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        String strDate = "";
        if (!Objects.isNull(date)) {
            strDate = simpleDateFormat.format(date);
        }
        return strDate;
    }
}

