/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.threads;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ThreadLocalUtils {
    private static ThreadLocal<Map<String, Object>> cache = new ThreadLocal();

    public static void set(String key, Object value) {
        if (!ThreadLocalUtils.isCaheIsNull()) {
            cache.get().put(key, value);
        } else {
            HashMap vmap = Maps.newHashMap();
            vmap.put(key, value);
            cache.set(vmap);
        }
    }

    public static Object getCache(String key) {
        Map<String, Object> map = cache.get();
        if (ThreadLocalUtils.isCaheIsNull()) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void removeByKey(String key) {
        if (!ThreadLocalUtils.isCaheIsNull()) {
            cache.get().remove(key);
        }
    }

    public static void remove() {
        cache.remove();
    }

    private static boolean isCaheIsNull() {
        return Objects.isNull(cache.get());
    }
}

