/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.http;

import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.utils.http.HttpsClientFactoryBean;
import cn.gtmap.estateplat.utils.DateUtils;
import cn.gtmap.estateplat.utils.UUID;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Component
public class HttpUtil {
    private static OkHttpClient okHttpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1000, 5L, TimeUnit.MINUTES)).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    HttpsClientFactoryBean httpClient;
    public static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static String sendPostFileRequest(String url, Map<String, String> params, String fileParamName, MultipartFile file, Map<String, String> headers) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(StandardCharsets.UTF_8);
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return null;
            }
            HttpPost httpPost = new HttpPost(url);
            if (!Objects.isNull(file)) {
                builder.addBinaryBody(fileParamName, file.getBytes(), ContentType.create((String)"multipart/form-data", (Charset)Consts.UTF_8), file.getOriginalFilename());
            }
            if (MapUtils.isNotEmpty(params)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addTextBody(entry.getKey(), entry.getValue(), ContentType.DEFAULT_TEXT);
                }
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            String uuid = UUIDGenerator.generate();
            logger.info("bh:{} sendPostFileRequest {}httpClientPost URL:{}", new Object[]{uuid, DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), httpPost});
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            logger.info("bh:{} sendPostFileRequest {}httpClientPost URL:{} result:{}", new Object[]{uuid, DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), httpPost, resultString});
        }
        catch (Exception e) {
            logger.error("http\u5de5\u5177\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return resultString;
    }

    public <T> T getGetData(JSONObject json, String url, Class<T> t, String jkname, String bh, HttpHeaders headers) {
        boolean jzscrc;
        if (StringUtils.isBlank((CharSequence)bh)) {
            bh = UUID.hex32();
        }
        boolean bl = jzscrc = url.contains("/wwsq/tsWwsqFjxx") || url.contains("/api/v2/logs") || url.contains("/storages/multipart/upload") || url.contains("zzgx/token");
        if (Boolean.TRUE.equals(jzscrc)) {
            logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getGetData,paramStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), null, url, jkname});
        } else {
            logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getGetData,paramStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), json.toJSONString(), url, jkname});
        }
        Object ss = null;
        if (!Objects.isNull(json)) {
            try {
                if (Objects.isNull(headers)) {
                    headers = new HttpHeaders();
                }
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                ss = this.restTemplate.getForObject(url, t, (Map)json);
                if (!Objects.isNull(ss)) {
                    logger.info("bh:{},\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a-url{}-,responseContent {} ", new Object[]{bh, url, JSON.toJSONString((Object)ss)});
                }
            }
            catch (Exception e) {
                logger.error("jsonStr:{} url:{} jkname:{} bh:{}\u8c03\u7528\u9519\u8bef:{}", new Object[]{null, url, jkname, bh, e});
            }
        }
        return (T)ss;
    }

    public <T> T getPostData(String jsonStr, String url, Class<T> t, String jkname, String bh, HttpHeaders headers) {
        boolean jzscrc;
        if (StringUtils.isBlank((CharSequence)bh)) {
            bh = UUID.hex32();
        }
        boolean bl = jzscrc = url.contains("/wwsq/tsWwsqFjxx") || url.contains("/api/v2/logs") || url.contains("/storages/multipart/upload") || url.contains("zzgx/token");
        if (Boolean.TRUE.equals(jzscrc)) {
            logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getPostData,jsonStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), null, url, jkname});
        } else {
            logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getPostData,jsonStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), jsonStr, url, jkname});
        }
        Object ss = null;
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            try {
                if (Objects.isNull(headers)) {
                    headers = new HttpHeaders();
                }
                MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
                headers.setContentType(type);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity((Object)jsonStr, (MultiValueMap)headers);
                ss = this.restTemplate.postForObject(url, (Object)formEntity, t, new Object[0]);
                if (!Objects.isNull(ss)) {
                    logger.info("bh:{},\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a-url{}-,responseContent {} ", new Object[]{bh, url, JSON.toJSONString((Object)ss)});
                }
            }
            catch (Exception e) {
                logger.error("jsonStr:{} url:{} jkname:{} bh:{}\u8c03\u7528\u9519\u8bef:{}", new Object[]{null, url, jkname, bh, e});
            }
        }
        return (T)ss;
    }

    public <T> T getPostData(String jsonStr, String url, Class<T> t, String jkname, String bh) {
        return this.getPostData(jsonStr, url, t, jkname, bh, null);
    }

    public <T> T getPostData(String jsonStr, String url, ParameterizedTypeReference<T> typeRef, String jkname, String bh, HttpHeaders headers) {
        Object ss;
        block11: {
            boolean jzscrc;
            if (StringUtils.isBlank((CharSequence)bh)) {
                bh = UUID.hex32();
            }
            boolean bl = jzscrc = url.contains("/wwsq/tsWwsqFjxx") || url.contains("/api/v2/logs") || url.contains("/rest/v1/wwsq/uploadFjxx") || url.contains("/rest/v1/wwsq/uploadBySlbhAndFjlx") || url.contains("/storages/multipart/upload") || url.contains("zzgx/token") || url.contains("wwsq/fjxxUpload");
            if (Boolean.TRUE.equals(jzscrc)) {
                logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getPostData,jsonStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), null, url, jkname});
            } else {
                logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getPostData,jsonStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), jsonStr, url, jkname});
            }
            ss = null;
            if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                try {
                    if (Objects.isNull(headers)) {
                        headers = new HttpHeaders();
                    }
                    MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
                    headers.setContentType(type);
                    headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                    org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity((Object)jsonStr, (MultiValueMap)headers);
                    ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, formEntity, typeRef, new Object[0]);
                    ss = exchange.getBody();
                    HttpHeaders responseHeaders = exchange.getHeaders();
                    if (Objects.isNull(ss)) break block11;
                    if (!Objects.isNull(responseHeaders)) {
                        try {
                            Field field = ss.getClass().getDeclaredField("responseHeaders");
                            if (!Objects.isNull(field)) {
                                field.setAccessible(true);
                                field.set(ss, responseHeaders);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.info("bh:{},\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a-url{}-,responseContent {}", new Object[]{bh, url, JSON.toJSONString((Object)ss)});
                }
                catch (Exception e) {
                    logger.error("jsonStr:{} url:{} jkname:{} bh:{}\u8c03\u7528\u9519\u8bef:{}", new Object[]{null, url, jkname, bh, e});
                }
            }
        }
        return (T)ss;
    }

    public <T> T getPostFormData(String jsonStr, String url, ParameterizedTypeReference<T> typeRef, String jkname, String bh, HttpHeaders headers) {
        boolean jzscrc;
        if (StringUtils.isBlank((CharSequence)bh)) {
            bh = UUID.hex32();
        }
        boolean bl = jzscrc = url.contains("/wwsq/tsWwsqFjxx") || url.contains("/api/v2/logs") || url.contains("/storages/multipart/upload") || url.contains("zzgx/token") || url.contains("wwsq/fjxxUpload");
        if (Boolean.TRUE.equals(jzscrc)) {
            logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getPostData,jsonStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), null, url, jkname});
        } else {
            logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}getPostData,jsonStr: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), jsonStr, url, jkname});
        }
        Object ss = null;
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            try {
                if (Objects.isNull(headers)) {
                    headers = new HttpHeaders();
                }
                MediaType type = MediaType.parseMediaType((String)"application/x-www-form-urlencoded");
                headers.setContentType(type);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
                Map params = (Map)JSON.parseObject((String)jsonStr, Map.class);
                ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, formEntity, typeRef, params);
                ss = exchange.getBody();
                HttpHeaders responseHeaders = exchange.getHeaders();
                if (!Objects.isNull(ss)) {
                    Field field;
                    if (!Objects.isNull(responseHeaders) && !Objects.isNull(field = ss.getClass().getDeclaredField("responseHeaders"))) {
                        field.setAccessible(true);
                        field.set(ss, responseHeaders);
                    }
                    logger.info("bh:{},\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a-url{}-,responseContent {}", new Object[]{bh, url, JSON.toJSONString((Object)ss)});
                }
            }
            catch (Exception e) {
                logger.error("jsonStr:{} url:{} jkname:{} bh:{}\u8c03\u7528\u9519\u8bef:{}", new Object[]{null, url, jkname, bh, e});
            }
        }
        return (T)ss;
    }

    public <T> T getPostData(String jsonStr, String url, ParameterizedTypeReference<T> typeRef, String jkname, String bh) {
        return this.getPostData(jsonStr, url, typeRef, jkname, bh, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendYcpostData(String jsonStr, String contentType, String url, Map<String, String> header) {
        if (url.contains("/wwsq/tsWwsqFjxx") || url.contains("/api/v2/logs") || url.contains("/storages/multipart/upload") || url.contains("/wwsq/swhyts") || url.contains("/net/savesqxx")) {
            logger.info("sendYcpostData,\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}sendYcpostData jsonStr: {} URL:{} contentType:{}", new Object[]{LocalDateTime.now(), null, url, contentType});
        }
        String responseContent = null;
        CloseableHttpClient closeableHttpClient = null;
        try {
            closeableHttpClient = (CloseableHttpClient)this.httpClient.getObject();
        }
        catch (Exception e) {
            logger.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "application/json;charset=UTF-8";
        }
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient closeHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        if (!Objects.isNull(jsonStr)) {
            StringEntity stringEntity = new StringEntity(jsonStr, "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        try {
            if (!Objects.isNull(closeableHttpClient)) {
                httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                HttpEntity httpEntity = httpResponse.getEntity();
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            logger.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
            responseContent = e.getMessage();
        }
        finally {
            try {
                if (!Objects.isNull(closeHttpClient)) {
                    closeHttpClient.close();
                }
                if (!Objects.isNull(httpResponse)) {
                    httpResponse.close();
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return responseContent;
    }

    public static StringBuffer getQueryString(String url, Map<String, String> queries) {
        StringBuffer sb = new StringBuffer(url);
        if (!Objects.isNull(queries) && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        return sb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String execNewCall(Request request) {
        try (Response response = okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new BizException("533", "\u8c03\u7528okhttp\u7684newCall\u65b9\u6cd5\u5f02\u5e38");
            }
            String string = response.body().string();
            return string;
        }
        catch (Exception e) {
            logger.error("okhttp3 put error >> ex = {} for url:{}", (Object)e.getMessage(), (Object)request.url());
            throw new BizException("533", e.getMessage());
        }
    }

    public static String getRequest(String url, Map<String, String> queries, Map<String, String> headers) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        Request.Builder builder = new Request.Builder();
        if (CollectionUtils.isEmpty(headers)) {
            builder.addHeader("Accept", "application/json");
            builder.addHeader("Content-Type", "application/json");
        } else {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Request request = builder.url(sb.toString()).build();
        return HttpUtil.execNewCall(request);
    }

    public static String get(String url, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Accept", "application/json");
        builder.addHeader("Content-Type", "application/json");
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).build();
        return HttpUtil.execNewCall(request);
    }

    public static String deleteRequest(String url, String jsonParams, Map<String, String> queries, Map<String, String> headers) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        RequestBody requestBody = null;
        if (StringUtils.isNotBlank((CharSequence)jsonParams)) {
            requestBody = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        }
        Request.Builder builder = new Request.Builder();
        if (CollectionUtils.isEmpty(headers)) {
            builder.addHeader("Accept", "application/json");
            builder.addHeader("Content-Type", "application/json");
        } else {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Request request = builder.url(sb.toString()).delete(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    public static String delete(String url, String jsonParams, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        RequestBody requestBody = null;
        if (StringUtils.isNotBlank((CharSequence)jsonParams)) {
            requestBody = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        }
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).delete(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    public static String putRequest(String url, String jsonParams, Map<String, String> queries, Map<String, String> headers) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        RequestBody requestBody = null;
        requestBody = StringUtils.isNotBlank((CharSequence)jsonParams) ? RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams) : RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        Request.Builder builder = new Request.Builder();
        if (CollectionUtils.isEmpty(headers)) {
            builder.addHeader("Accept", "application/json");
            builder.addHeader("Content-Type", "application/json");
        } else {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Request request = builder.url(sb.toString()).put(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    public static String put(String url, String jsonParams, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        RequestBody requestBody = null;
        requestBody = StringUtils.isNotBlank((CharSequence)jsonParams) ? RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams) : RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).put(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    public static String postRequest(String url, String jsonParams, Map<String, String> queries, Map<String, String> headers) {
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        RequestBody requestBody = null;
        requestBody = StringUtils.isNotBlank((CharSequence)jsonParams) ? RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams) : RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        Request.Builder builder = new Request.Builder();
        if (CollectionUtils.isEmpty(headers)) {
            builder.addHeader("Accept", "application/json");
            builder.addHeader("Content-Type", "application/json");
        } else {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Request request = builder.url(sb.toString()).post(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    public static String post(String url, String jsonParams, Map<String, String> queries, String authorizationHeader) {
        String bh = UUID.hex32();
        logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}sendYcpostData jsonStr: {} URL:{}", new Object[]{bh, LocalDateTime.now(), jsonParams, url});
        StringBuffer sb = HttpUtil.getQueryString(url, queries);
        RequestBody requestBody = null;
        requestBody = StringUtils.isNotBlank((CharSequence)jsonParams) ? RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams) : RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).post(requestBody).build();
        String result = HttpUtil.execNewCall(request);
        logger.info("bh:{},\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}sendYcpostData result: {} URL:{} contentType:{}", new Object[]{bh, LocalDateTime.now(), result, url});
        return result;
    }

    public static String postFormParams(String url, Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (!Objects.isNull(params) && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        return HttpUtil.execNewCall(request);
    }

    public static String postJsonParams(String url, String jsonParams) {
        RequestBody requestBody = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    public static String postXmlParams(String url, String xml) {
        RequestBody requestBody = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return HttpUtil.execNewCall(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClientPost(String url, String contentType, Map<String, String> param, Map<String, String> header, HttpEntity entity) {
        String result = "";
        logger.info(",httpClientPost,\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}httpClientPost param: {} URL:{} header:{}", new Object[]{LocalDateTime.now(), JSON.toJSONString(param), url, JSON.toJSONString(header)});
        CloseableHttpClient closeableHttpClient = HttpUtil.createSSLClientDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig config = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).setConnectionRequestTimeout(120000).build();
            httpPost.setConfig(config);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                httpPost.setHeader("Content-Type", contentType);
            }
            if (MapUtils.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (MapUtils.isNotEmpty(param)) {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(formparams, Consts.UTF_8);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if (!Objects.isNull(entity)) {
                httpPost.setEntity(entity);
            }
            CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            try {
                int n = httpResponse.getStatusLine().getStatusCode();
                if (n == 200) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                }
            }
            finally {
                if (!Objects.isNull(httpResponse)) {
                    httpResponse.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (Exception e) {
                logger.error("{}", (Throwable)e);
            }
        }
        logger.info("httpClientPost,\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a{}httpClientPost URL:{} result:{}", new Object[]{LocalDateTime.now(), url, result});
        return result;
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            logger.error("KeyManagementException:", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmException:", (Throwable)e);
        }
        catch (KeyStoreException e) {
            logger.error("KeyStoreException:", (Throwable)e);
        }
        return HttpClients.createDefault();
    }
}

