/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.encryption.sm4;

import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.encryption.sm4.SM4;
import cn.gtmap.ai.core.utils.encryption.sm4.SM4Context;
import cn.gtmap.ai.core.utils.escape.EscapeUtil;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class Sm4Util {
    private static Logger logger = LoggerFactory.getLogger(Sm4Util.class);
    public static Pattern p = Pattern.compile("\\s*|\t|\r|\n");
    public static String HEXKEY;
    public static final String ENCODING_GBK = "GBK";

    @Value(value="${encrypt.sm4.hexkey:045b756a187fb6cc68b3438946e93d3b73c2d5ec21cd8e01659a99f759abed940dcf78005f24326ea9c00281707a851f18e6764234f02d5e26e9548bcc9b137fa7c3f0956bafeaa47199f8eb470a1cadb7396bc1c5336c18212c2814768abfbabf7532552d4116d58ef616738a991216f427f172aa08accd5f}")
    public void setSm2PublicKey(String hexkey) {
        HEXKEY = hexkey = Sm2lib.pzxDecode(hexkey);
    }

    public static String encryptEcb(String paramStr) {
        try {
            if (StringUtils.isBlank((CharSequence)paramStr)) {
                return null;
            }
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = HEXKEY.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetkeyEnc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4CryptEcb(ctx, Sm4Util.strToByteGbk(paramStr));
            String cipherText = Sm4Util.encodeByteToBase64Str(encrypted);
            if (!Objects.isNull(cipherText) && cipherText.trim().length() > 0) {
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            cipherText = EscapeUtil.escape(cipherText);
            return cipherText;
        }
        catch (Exception e) {
            logger.error("encryptData_ECB plainText:{}  ERROR:{}", (Object)paramStr, (Object)e);
            return paramStr;
        }
    }

    public static String decryptEcb(String cipherText) {
        try {
            String oldCipherText = cipherText;
            if (StringUtils.isBlank((CharSequence)cipherText)) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)(cipherText = EscapeUtil.unescape(cipherText))) || StringUtils.equals((CharSequence)oldCipherText, (CharSequence)cipherText)) {
                return oldCipherText;
            }
            if (StringUtils.isBlank((CharSequence)HEXKEY)) {
                return cipherText;
            }
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = HEXKEY.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetkeyDec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4CryptEcb(ctx, Sm4Util.decodeBase64StrToByte(cipherText.replace(" ", "+")));
            return Sm4Util.byteToStrGbk(decrypted);
        }
        catch (Exception e) {
            logger.error("decryptData_ECB plainText:{}  ", (Object)cipherText);
            return cipherText;
        }
    }

    public static byte[] strToByteGbk(String str) {
        return Sm4Util.strToByte(str, ENCODING_GBK);
    }

    public static String byteToStrGbk(byte[] b) {
        return Sm4Util.byteToStr(b, ENCODING_GBK);
    }

    public static String byteToStr(byte[] b, String encode) {
        String str = null;
        if (!Objects.isNull(b)) {
            try {
                str = new String(b, encode);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("StringUtils:byteToStrUtf8", (Throwable)e);
            }
        }
        return str;
    }

    public static byte[] strToByte(String str, String encode) {
        byte[] b = null;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                b = str.getBytes(encode);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("StringUtils:strToByteUtf8", (Throwable)e);
            }
        }
        return b;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (Objects.isNull(hexString) || "".equals(hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(Sm4Util.charToByte(hexChars[pos]) << 4 | Sm4Util.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String encodeByteToBase64Str(byte[] bytes) {
        String base64Str = "";
        if (!Objects.isNull(bytes)) {
            base64Str = Base64Utils.encodeToString((byte[])bytes);
        }
        return base64Str;
    }

    public static byte[] decodeBase64StrToByte(String base64Str) {
        byte[] bytes = null;
        if (StringUtils.isNotBlank((CharSequence)base64Str)) {
            bytes = Base64Utils.decodeFromString((String)base64Str);
        }
        return bytes;
    }
}

