/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.encryption;

import cn.gtmap.ai.core.annotation.encrypt.ItemEncrypt;
import cn.gtmap.ai.core.annotation.encrypt.ObjEncrypt;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.utils.encryption.md5.Md5;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.encryption.sm4.Sm4Util;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private static final Logger log = LoggerFactory.getLogger(EncryptUtil.class);

    public static String encryptStr(String str, EncryptTypeEnum encryptType) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        String encryptedStr = str;
        encryptedStr = EncryptTypeEnum.MD5Salt == encryptType ? Md5.md5Sign(str) : (EncryptTypeEnum.SM4 == encryptType ? Sm4Util.encryptEcb(str) : (EncryptTypeEnum.AES == encryptType ? EncryptUtil.encrypt(str, "9LQwYy7tsonieMqx") : Sm2lib.encode(str)));
        return encryptedStr;
    }

    public static String decryptStr(String str, EncryptTypeEnum encryptType) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        str = EncryptTypeEnum.SM4 == encryptType ? Sm4Util.decryptEcb(str) : (EncryptTypeEnum.AES == encryptType ? EncryptUtil.decrypt(str, "9LQwYy7tsonieMqx") : Sm2lib.decode(str));
        return str;
    }

    public static String encrypt(String sSrc, String keyStr) {
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{keyStr, sSrc})) {
                byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
                SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(1, skeySpec);
                byte[] encrypted = cipher.doFinal(sSrc.getBytes(StandardCharsets.UTF_8));
                return Base64.encodeBase64String((byte[])encrypted);
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.info("ERROR1:", (Object)e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            log.info("ERROR2:", (Object)e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.info("ERROR3:", (Object)e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            log.info("ERROR4:", (Object)e.getMessage());
        }
        catch (BadPaddingException e) {
            log.info("ERROR5:", (Object)e.getMessage());
        }
        return null;
    }

    public static String decrypt(String sSrc, String keyStr) {
        try {
            if (StringUtils.isNotBlank((CharSequence)sSrc)) {
                byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
                SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, skeySpec);
                byte[] encrypted = Base64.decodeBase64((String)sSrc);
                byte[] original = cipher.doFinal(encrypted);
                return new String(original, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6 ERROR:", (Object)e.getMessage());
        }
        return sSrc;
    }

    public static boolean decryptObj(Object object) {
        boolean jm = true;
        if (object instanceof List) {
            Object obj;
            List objectList = (List)object;
            Iterator iterator = objectList.iterator();
            while (iterator.hasNext() && (jm = EncryptUtil.decryptObjItems(obj = iterator.next()))) {
            }
        } else {
            jm = EncryptUtil.decryptObjItems(object);
        }
        return jm;
    }

    private static boolean decryptObjItems(Object object) {
        Field[] fields;
        boolean jm = true;
        ObjEncrypt objEncryptAnnotation = object.getClass().getAnnotation(ObjEncrypt.class);
        if (!Objects.isNull(objEncryptAnnotation) && !Objects.isNull(fields = object.getClass().getDeclaredFields())) {
            for (Field field : fields) {
                ItemEncrypt itemEncryptAnnotation = field.getAnnotation(ItemEncrypt.class);
                if (Objects.isNull(itemEncryptAnnotation)) continue;
                try {
                    field.setAccessible(true);
                    Object objValue = field.get(object);
                    if (Objects.isNull(objValue)) continue;
                    if (objValue instanceof String) {
                        String objStr = (String)objValue;
                        String objStrNew = EncryptUtil.decryptStr(objStr, itemEncryptAnnotation.encryptType());
                        if (StringUtils.equals((CharSequence)objStr, (CharSequence)objStrNew)) {
                            jm = false;
                            break;
                        }
                        field.set(object, objStrNew);
                        continue;
                    }
                    jm = EncryptUtil.decryptObj(objValue);
                    if (jm) continue;
                    break;
                }
                catch (Exception e) {
                    log.error(" \u89e3\u5bc6 {}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", object.getClass(), (Object)field.getName());
                    jm = false;
                }
            }
        }
        return true;
    }
}

