/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.desensitization;

import cn.gtmap.ai.core.annotation.desensitization.ItemDesensitize;
import cn.gtmap.ai.core.annotation.desensitization.ObjDesensitize;
import cn.gtmap.ai.core.base.ReturnResultItem;
import cn.gtmap.ai.core.enums.SensitiveTypeEnum;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesensitizedUtil {
    private static Logger logger = LoggerFactory.getLogger(DesensitizedUtil.class);
    public static final String DATATM = "dataTm";
    public static final String ITSELF = "itself";

    public static String stringDesensitize(String str, SensitiveTypeEnum annotationType) {
        String desensitizedStr = str;
        switch (annotationType) {
            case CHINESE_NAME: {
                desensitizedStr = DesensitizedUtil.chineseName(str);
                break;
            }
            case ID_CARD: {
                desensitizedStr = DesensitizedUtil.idCardNum(str);
                break;
            }
            case FIXED_PHONE: {
                desensitizedStr = DesensitizedUtil.fixedPhone(str);
                break;
            }
            case MOBILE_PHONE: {
                desensitizedStr = DesensitizedUtil.mobilePhone(str);
                break;
            }
            case ADDRESS: {
                desensitizedStr = DesensitizedUtil.address(str);
                break;
            }
            case EMAIL: {
                desensitizedStr = DesensitizedUtil.email(str);
                break;
            }
            case BANK_CARD: {
                desensitizedStr = DesensitizedUtil.bankCard(str);
                break;
            }
            case COMPANY_BANK_CARD: {
                desensitizedStr = DesensitizedUtil.companyBankCard(str);
                break;
            }
        }
        return desensitizedStr;
    }

    public static String listStringDesensitize(String strings, String separator, SensitiveTypeEnum annotationType) {
        String[] strList = strings.split(separator);
        ArrayList<String> list1 = new ArrayList<String>();
        switch (annotationType) {
            case CHINESE_NAME: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.chineseName(str));
                }
                break;
            }
            case ID_CARD: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.idCardNum(str));
                }
                break;
            }
            case FIXED_PHONE: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.fixedPhone(str));
                }
                break;
            }
            case MOBILE_PHONE: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.mobilePhone(str));
                }
                break;
            }
            case ADDRESS: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.address(str));
                }
                break;
            }
            case EMAIL: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.email(str));
                }
                break;
            }
            case BANK_CARD: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.bankCard(str));
                }
                break;
            }
            case COMPANY_BANK_CARD: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.companyBankCard(str));
                }
                break;
            }
        }
        return Joiner.on((String)separator).join(list1);
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.right((String)fullName, (int)1);
        return StringUtils.leftPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String idCardNum(String id) {
        if (StringUtils.isBlank((CharSequence)(id = StringUtils.trim((String)id)))) {
            return "";
        }
        if (id.length() == 18) {
            return StringUtils.left((String)id, (int)6).concat(StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)12, (String)"*"));
        }
        if (id.length() == 15) {
            return StringUtils.left((String)id, (int)6).concat(StringUtils.leftPad((String)StringUtils.right((String)id, (int)3), (int)9, (String)"*"));
        }
        return StringUtils.leftPad((String)StringUtils.right((String)id, (int)6), (int)StringUtils.length((CharSequence)id), (String)"*");
    }

    public static String idCardNumByBirthday(String id) {
        if (StringUtils.isBlank((CharSequence)(id = StringUtils.trim((String)id)))) {
            return "";
        }
        return StringUtils.left((String)id, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)(StringUtils.length((CharSequence)id) - 9), (String)"*"), (String)"*"));
    }

    public static String fixedPhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String mobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)(num = StringUtils.trim((String)num)))) {
            return "";
        }
        if (11 != num.trim().length()) {
            return num;
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)(StringUtils.length((CharSequence)num) - 2), (String)"*"), (String)"*"));
    }

    public static String address(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.leftPad((String)StringUtils.right((String)address, (int)6), (int)length, (String)"*");
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)0), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String companyBankCard(String companyBardNum) {
        if (StringUtils.isBlank((CharSequence)companyBardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)companyBardNum);
        return StringUtils.rightPad((String)StringUtils.left((String)companyBardNum, (int)2), (int)length, (String)"*");
    }

    public static String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        String pwd = StringUtils.left((String)password, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)password), (String)"*");
    }

    public static void desensitizeObj(Object originalObj) {
        ObjDesensitize objDesensitizeAnnotation = originalObj.getClass().getAnnotation(ObjDesensitize.class);
        if (Objects.isNull(objDesensitizeAnnotation)) {
            return;
        }
        Field[] fields = originalObj.getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            ItemDesensitize itemDesensitizeAnnotation = field.getAnnotation(ItemDesensitize.class);
            try {
                String objValue;
                field.setAccessible(true);
                if (Objects.isNull(itemDesensitizeAnnotation) || !StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(originalObj)))) continue;
                field.set(originalObj, DesensitizedUtil.stringDesensitize(objValue, itemDesensitizeAnnotation.type()));
            }
            catch (Exception e) {
                logger.error("desensitizeObj \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", originalObj.getClass(), (Object)field.getName());
            }
        }
    }

    public static void desensitizeResult(Object data) {
        if (data instanceof Collection) {
            DesensitizedUtil.desensitizeCollection((Collection)data);
        } else if (data instanceof ReturnResultItem) {
            DesensitizedUtil.desensitizeReturnResultItem((ReturnResultItem)data);
        } else if (data instanceof Map) {
            DesensitizedUtil.desensitizeMap((Map)data);
        }
    }

    private static void desensitizeCollection(Collection collection) {
        for (Object o : collection) {
            if (Objects.isNull(o)) continue;
            if (o instanceof Collection) {
                DesensitizedUtil.desensitizeCollection((Collection)o);
                continue;
            }
            if (o instanceof ReturnResultItem) {
                DesensitizedUtil.desensitizeReturnResultItem((ReturnResultItem)o);
                continue;
            }
            if (!(o instanceof Map)) continue;
            DesensitizedUtil.desensitizeMap((Map)o);
        }
    }

    private static void desensitizeReturnResultItem(ReturnResultItem returnResultItem) {
        ObjDesensitize tObjDesensitizeAnnotation = returnResultItem.getClass().getAnnotation(ObjDesensitize.class);
        if (Objects.isNull(tObjDesensitizeAnnotation)) {
            return;
        }
        Field[] fields = returnResultItem.getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            ItemDesensitize itemDesensitizeAnnotation = field.getAnnotation(ItemDesensitize.class);
            try {
                Field targetField;
                field.setAccessible(true);
                Object obj = field.get(returnResultItem);
                if (Objects.isNull(obj)) continue;
                if (obj instanceof Collection) {
                    DesensitizedUtil.desensitizeCollection((Collection)obj);
                    continue;
                }
                if (obj instanceof Map) {
                    DesensitizedUtil.desensitizeMap((Map)obj);
                    continue;
                }
                if (obj instanceof ReturnResultItem) {
                    DesensitizedUtil.desensitizeReturnResultItem((ReturnResultItem)obj);
                    continue;
                }
                if (Objects.isNull(itemDesensitizeAnnotation) || StringUtils.isEmpty((CharSequence)itemDesensitizeAnnotation.targetFieldName()) || Objects.isNull(targetField = returnResultItem.getClass().getDeclaredField(itemDesensitizeAnnotation.targetFieldName()))) continue;
                targetField.setAccessible(true);
                targetField.set(returnResultItem, null);
            }
            catch (Exception e) {
                logger.error("\u8131\u654f{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", returnResultItem.getClass(), (Object)itemDesensitizeAnnotation.targetFieldName());
            }
        }
    }

    private static void desensitizeMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
            Object o = stringObjectEntry.getValue();
            if (Objects.isNull(o)) continue;
            if (o instanceof Collection) {
                DesensitizedUtil.desensitizeCollection((Collection)o);
                continue;
            }
            if (o instanceof ReturnResultItem) {
                DesensitizedUtil.desensitizeReturnResultItem((ReturnResultItem)o);
                continue;
            }
            if (!(o instanceof Map)) continue;
            DesensitizedUtil.desensitizeMap((Map)o);
        }
    }
}

