/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.bean;

import cn.gtmap.ai.core.utils.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ObjectUtils;

public class BeanConvertUtil {
    public static final Logger logger = LoggerFactory.getLogger(BeanConvertUtil.class);

    public static <T> T copy(Object src, Class<T> targetType) {
        String target = null;
        if (targetType == String.class && src instanceof String) {
            target = src.toString();
        } else {
            try {
                target = (String)targetType.newInstance();
                BeanWrapperImpl targetBean = new BeanWrapperImpl((Object)target);
                BeanMap srcBean = new BeanMap(src);
                for (Object key : srcBean.keySet()) {
                    String srcPropertyName = key + "";
                    Object srcPropertyVal = srcBean.get(key);
                    Class srcPropertyType = srcBean.getType(srcPropertyName);
                    Class targetPropertyType = targetBean.getPropertyType(srcPropertyName);
                    if ("class".equals(srcPropertyName) || Objects.isNull(targetPropertyType)) continue;
                    if (srcPropertyType == targetPropertyType) {
                        if (srcPropertyVal instanceof List) {
                            PropertyDescriptor propertyDescriptor = targetBean.getPropertyDescriptor(srcPropertyName);
                            Type[] listParam = propertyDescriptor.getWriteMethod().getGenericParameterTypes();
                            Type[] actualTypeArguments = ((ParameterizedType)listParam[0]).getActualTypeArguments();
                            List<?> temp = BeanConvertUtil.copyList((List)srcPropertyVal, Class.forName(actualTypeArguments[0].getTypeName()));
                            targetBean.setPropertyValue(srcPropertyName, temp);
                            continue;
                        }
                        targetBean.setPropertyValue(srcPropertyName, srcPropertyVal);
                        continue;
                    }
                    if (Objects.isNull(srcPropertyVal)) continue;
                    Object targetPropertyVal = targetPropertyType.newInstance();
                    BeanWrapperImpl targetPropertyBean = new BeanWrapperImpl(targetPropertyVal);
                    BeanMap srcPropertyBean = new BeanMap(srcPropertyVal);
                    for (Object srcPropertyBeanKey : srcPropertyBean.keySet()) {
                        String srcPropertyBeanPropertyName = srcPropertyBeanKey + "";
                        Object srcPropertyBeanPropertyVal = srcPropertyBean.get(srcPropertyBeanKey);
                        Class srcPropertyBeanPropertyType = srcPropertyBean.getType(srcPropertyBeanPropertyName);
                        Class targetPropertyBeanPropertyType = targetPropertyBean.getPropertyType(srcPropertyBeanPropertyName);
                        if ("class".equals(srcPropertyBeanPropertyName) || Objects.isNull(targetPropertyBeanPropertyType) || srcPropertyBeanPropertyType != targetPropertyBeanPropertyType) continue;
                        targetPropertyBean.setPropertyValue(srcPropertyBeanPropertyName, srcPropertyBeanPropertyVal);
                    }
                    targetBean.setPropertyValue(srcPropertyName, targetPropertyBean.getWrappedInstance());
                }
            }
            catch (Exception e) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return (T)target;
    }

    public static <T> List<T> copyList(List srcList, Class<T> targetType) {
        ArrayList<T> newList = new ArrayList<T>();
        for (Object entity : srcList) {
            newList.add(BeanConvertUtil.copy(entity, targetType));
        }
        return newList;
    }

    public static Object convertMap(Map map, Class type) {
        Object obj = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            obj = type.newInstance();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName)) continue;
                Object value = null;
                try {
                    value = map.get(propertyName);
                    if ("".equals(value)) {
                        value = null;
                    }
                    Object[] args = new Object[]{value};
                    descriptor.getWriteMethod().invoke(obj, args);
                    continue;
                }
                catch (InvocationTargetException e) {
                    logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cmap\u8f6cbean\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
                }
            }
        }
        catch (IntrospectionException e) {
            logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cmap\u8f6cbean\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cmap\u8f6cbean\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return obj;
    }

    public static Map convertBean(Object bean) {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if ("class".equals(propertyName)) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result instanceof String) {
                    if ("zl".equals(propertyName)) {
                        returnMap.put(propertyName, result.toString());
                        continue;
                    }
                    returnMap.put(propertyName, StringUtil.xssEncode(result.toString()));
                    continue;
                }
                returnMap.put(propertyName, result);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("bean\u8f6c\u6362\u5de5\u5177\u7c7b\uff0cbean\u8f6cmap\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return returnMap;
    }

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass) {
        Object t = null;
        try {
            t = json instanceof String ? JSON.parseObject((String)json.toString(), tClass) : JSON.parseObject((String)JSON.toJSONString((Object)json), tClass);
        }
        catch (Exception e) {
            logger.error("Bean\u8f6c\u6362\u5de5\u5177\u7c7bgetBeanByJsonObj\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
        }
        return (T)t;
    }

    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass) {
        List t = null;
        try {
            t = obj instanceof String ? JSON.parseArray((String)obj.toString(), tClass) : JSON.parseArray((String)JSON.toJSONString((Object)obj), tClass);
        }
        catch (Exception var4) {
            logger.error("Bean\u8f6c\u6362\u5de5\u5177\u7c7bgetBeanListByJsonArray\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)var4);
        }
        return t;
    }

    public static <T> void nullToEmpty(T bean) {
        Field[] field = bean.getClass().getDeclaredFields();
        for (int j = 0; j < field.length; ++j) {
            String name = field[j].getName();
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            String type = field[j].getGenericType().toString();
            if (!"class java.lang.String".equals(type)) continue;
            try {
                Method mGet = bean.getClass().getMethod("get" + name, new Class[0]);
                String value = (String)mGet.invoke(bean, new Object[0]);
                if (!Objects.isNull(value) && !"".equals(value)) continue;
                Method mSet = bean.getClass().getMethod("set" + name, String.class);
                mSet.invoke(bean, new String(""));
                continue;
            }
            catch (Exception e) {
                logger.error("Bean\u8f6c\u6362\u5de5\u5177\u7c7bnullToEmpty\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
    }

    public static boolean allFieldIsNull(Object o, String ignoreField) {
        try {
            for (Field field : o.getClass().getDeclaredFields()) {
                Object object;
                field.setAccessible(true);
                if (StringUtils.equals((CharSequence)field.getName(), (CharSequence)ignoreField) || StringUtils.equals((CharSequence)field.getName(), (CharSequence)"serialVersionUID") || !((object = field.get(o)) instanceof CharSequence) || ObjectUtils.isEmpty((Object)object)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public static <T> T copyObject(Object object, Object objectNew, Class<T> tClass) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)object), JSONObject.class);
        JSONObject jsonObjectNew = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)objectNew, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.class);
        jsonObject.putAll((Map)jsonObjectNew);
        return (T)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject), tClass);
    }
}

