/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.token.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.PzxException;
import cn.gtmap.ai.core.service.token.application.AiXtDsfxtjrTokenService;
import cn.gtmap.ai.core.service.token.domian.model.AiXtDsfxtjr;
import cn.gtmap.ai.core.service.token.domian.model.AiXtJkgl;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.domian.model.sfmyancheng.SfmYanChengJrcsDto;
import cn.gtmap.ai.core.service.token.domian.model.sfmyancheng.SfmYanChengTokenDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service(value="sfmyanchengTokenServiceImpl")
public class SfmYanChengTokenServiceImpl
implements AiXtDsfxtjrTokenService {
    private static final Logger log = LoggerFactory.getLogger(SfmYanChengTokenServiceImpl.class);

    @Override
    public String getToken(JkglModel jkglModel, AiXtJkgl aiXtJkglToken, AiXtDsfxtjr aiXtDsfxtjr) {
        SfmYanChengTokenDto sfmYanChengTokenDto = new SfmYanChengTokenDto();
        String jrqtcs = aiXtDsfxtjr.getJrcs();
        SfmYanChengJrcsDto sfmYanChengJrcs = null;
        if (StringUtils.isNotBlank((CharSequence)jrqtcs) && JSONValidator.from((String)jrqtcs).validate()) {
            sfmYanChengJrcs = (SfmYanChengJrcsDto)JSON.parseObject((String)jrqtcs, SfmYanChengJrcsDto.class);
        }
        if (Objects.isNull(sfmYanChengJrcs)) {
            throw new PzxException("dsfxtjr id:" + aiXtDsfxtjr.getXtjrid() + " jrcs\u5b57\u6bb5");
        }
        String appId = sfmYanChengJrcs.getAppId();
        String appKey = sfmYanChengJrcs.getAppKey();
        String invokingServiceUrl = sfmYanChengJrcs.getInvokingServiceUrl();
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appKey) || StringUtils.isBlank((CharSequence)invokingServiceUrl)) {
            throw new PzxException("dsfxtjr id:" + aiXtDsfxtjr.getXtjrid() + " jrcs\u5b57\u6bb5appId\u3001appKey\u3001invokingServiceUrl");
        }
        try {
            invokingServiceUrl = SfmYanChengTokenServiceImpl.getEncodeUrl(invokingServiceUrl);
        }
        catch (Exception e) {
            log.error("SfmYanChengTokenServiceImpl getEncodeUrl \u5931\u8d25", (Throwable)e);
        }
        String invokingServiceRequestMethod = "POST";
        String currTime = System.currentTimeMillis() + "";
        String generateTokenUrl = aiXtJkglToken.getJkdz();
        String sign = null;
        try {
            sign = this.gatewaySignEncode(appId, appKey, currTime);
        }
        catch (Exception e) {
            log.error("SfmYanChengTokenServiceImpl gatewaySignEncode \u5931\u8d25", (Throwable)e);
        }
        log.info("sign:{},gateway_rtime\uff1a{}", (Object)sign, (Object)currTime);
        JSONObject jsonObject = null;
        try {
            jsonObject = SfmYanChengTokenServiceImpl.httpRequestFw(generateTokenUrl, "POST", appId, currTime, sign);
        }
        catch (Exception e) {
            log.error("httpRequestFw", (Throwable)e);
            throw new BizException(ErrorEnum.SERVICE_ERROR);
        }
        log.info("generateTokenUrl:{},jsonObject\uff1a{}", (Object)generateTokenUrl, (Object)jsonObject);
        JSONObject jsonObjectBody = JSONObject.parseObject((String)jsonObject.getString("body"));
        if (!Objects.isNull(jsonObjectBody)) {
            String codeValue;
            String accessToken = jsonObjectBody.getString("access_token");
            String secretKey = SfmYanChengTokenServiceImpl.aesDecode(appKey, accessToken);
            String sign1 = null;
            try {
                sign1 = this.gatewaySignEncode(appId, secretKey, currTime);
            }
            catch (Exception e) {
                log.error("gatewaySignEncode:", (Throwable)e);
            }
            log.info("sign:{},gateway_rtime\uff1a{}", (Object)sign1, (Object)currTime);
            sfmYanChengTokenDto.setSign(sign1);
            JSONObject serviceJsonData = null;
            try {
                serviceJsonData = SfmYanChengTokenServiceImpl.httpRequestFw(invokingServiceUrl, invokingServiceRequestMethod, appId, currTime, sign1);
            }
            catch (Exception e) {
                log.error("httpRequestFw:", (Throwable)e);
            }
            if (!Objects.isNull(serviceJsonData) && StringUtils.isBlank((CharSequence)(codeValue = serviceJsonData.getString("resultCode")))) {
                codeValue = serviceJsonData.getString("code");
            }
        } else {
            log.error("\u83b7\u53d6token\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u54cd\u5e94\u6570\u636e\u4e2d\u7684\u9519\u8bef\u7801\u548c\u9519\u8bef\u4fe1\u606f\u3002");
            throw new BizException(ErrorEnum.SERVICE_ERROR);
        }
        sfmYanChengTokenDto.setGatewayRtime(currTime);
        return JSON.toJSONString((Object)sfmYanChengTokenDto);
    }

    public static String getEncodeUrl(String url) throws Exception {
        String[] urlStr = url.split("\\?");
        int yzi = 2;
        if (urlStr.length < 1) {
            throw new Exception("\u8bf7\u8f93\u5165\u6b63\u786e\u7684url\u5730\u5740");
        }
        StringBuilder urlSb = new StringBuilder(urlStr[0]);
        urlSb.append("?");
        if (urlStr.length == yzi) {
            String[] urlParams;
            for (String param : urlParams = urlStr[1].split("&")) {
                String[] paramKv = param.split("=");
                urlSb.append(paramKv[0]);
                urlSb.append("=");
                if (paramKv.length == yzi) {
                    urlSb.append(URLEncoder.encode(paramKv[1], "UTF-8"));
                } else {
                    urlSb.append("");
                }
                urlSb.append("&");
            }
            url = StringUtils.substringBeforeLast((String)urlSb.toString(), (String)"&");
        } else if (urlStr.length > yzi) {
            throw new Exception("\u65e0\u6cd5\u5904\u7406\u5f53\u524d\u7c7b\u578b\u7684url\u5730\u5740");
        }
        return url;
    }

    public String gatewaySignEncode(String appId, String appKey, String rtime) throws Exception {
        String inputString = appId + rtime;
        return this.encode(appKey, inputString);
    }

    private String encode(String appKey, String inputStr) throws Exception {
        Mac hmacSha256 = Mac.getInstance("HmacSHA256");
        byte[] keyBytes = appKey.getBytes(StandardCharsets.UTF_8);
        hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256"));
        byte[] hmacSha256Bytes = hmacSha256.doFinal(inputStr.getBytes(StandardCharsets.UTF_8));
        String sign = new String(Base64.encodeBase64((byte[])hmacSha256Bytes), StandardCharsets.UTF_8);
        return sign;
    }

    public static JSONObject httpRequestFw(String requestUrl, String requestMethod, String appIdorSecretKey, String currTime, String sign) throws Exception {
        JSONObject jsonObject = null;
        StringBuilder builder = new StringBuilder();
        InputStream inputStream = null;
        HttpURLConnection httpUrlConnection = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferReader = null;
        try {
            URL url = new URL(requestUrl);
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setRequestMethod(requestMethod);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setRequestProperty("gateway_appid", appIdorSecretKey);
            httpUrlConnection.setRequestProperty("gateway_rtime", currTime);
            httpUrlConnection.setRequestProperty("gateway_sig", sign);
            httpUrlConnection.connect();
            int code = httpUrlConnection.getResponseCode();
            inputStream = 200 == code ? httpUrlConnection.getInputStream() : httpUrlConnection.getErrorStream();
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            bufferReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferReader.readLine()) != null) {
                builder.append(str);
            }
            String buffer2str = builder.toString();
            jsonObject = JSONObject.parseObject((String)buffer2str);
        }
        catch (ConnectException ce) {
            log.error("Server connect time out! ", (Throwable)ce);
            throw new ConnectException();
        }
        catch (IOException ioe) {
            log.error("ioException request error:", (Throwable)ioe);
            throw new IOException();
        }
        catch (Exception e) {
            log.error("http request error! ", (Throwable)e);
            throw new Exception();
        }
        finally {
            try {
                if (!Objects.isNull(bufferReader)) {
                    bufferReader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                if (!Objects.isNull(inputStreamReader)) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                if (!Objects.isNull(inputStream)) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (!Objects.isNull(httpUrlConnection)) {
                httpUrlConnection.disconnect();
            }
        }
        return jsonObject;
    }

    public static String aesDecode(String encodeRules, String content) {
        String ivStr = "AESCBCPKCS5Paddi";
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(encodeRules.getBytes());
            keygen.init(128, secureRandom);
            SecretKey originalKey = keygen.generateKey();
            byte[] raw = originalKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(ivStr.getBytes(StandardCharsets.UTF_8)));
            byte[] byteContent = new BASE64Decoder().decodeBuffer(content);
            byte[] byteDecode = cipher.doFinal(byteContent);
            String aesDecode = new String(byteDecode, StandardCharsets.UTF_8);
            return aesDecode;
        }
        catch (Exception e) {
            log.error("aesDecode \u5931\u8d25! ", (Throwable)e);
            return null;
        }
    }
}

