/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.ZdlxEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.setting.application.AiXtZdService;
import cn.gtmap.ai.core.service.setting.domian.model.AiXtZd;
import cn.gtmap.ai.core.service.setting.query.AiXtZdQuery;
import cn.gtmap.ai.core.service.storage.application.OlcommonFjxxOperateService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.model.HlwFjxmModel;
import cn.gtmap.ai.core.service.storage.domain.model.HlwFjxxModel;
import cn.gtmap.ai.core.service.storage.domain.repository.AiViewHlwFjxmRepository;
import cn.gtmap.ai.core.service.storage.domain.repository.AiViewHlwFjxxRepository;
import cn.gtmap.ai.core.service.storage.dto.FjxxQuery;
import cn.gtmap.ai.core.service.storage.dto.HlwFjxmSaveDto;
import cn.gtmap.ai.core.service.storage.dto.HlwFjxxOperateDto;
import cn.gtmap.ai.core.service.storage.dto.HlwFjxxSaveDto;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OlcommonFjxxOperateServiceImpl
implements OlcommonFjxxOperateService {
    private static final Logger log = LoggerFactory.getLogger(OlcommonFjxxOperateServiceImpl.class);
    @Autowired
    private AiViewHlwFjxmRepository aiViewHlwFjxmRepository;
    @Autowired
    private AiViewHlwFjxxRepository aiViewHlwFjxxRepository;
    @Autowired
    private AiXtZdService zdService;

    @Override
    public IError deleteFjxxByFjid(HlwFjxxOperateDto hlwFjxxOperateDto) {
        File deleteFile;
        String fjid = hlwFjxxOperateDto.getFjid();
        if (StringUtils.isBlank((CharSequence)fjid)) {
            return ErrorEnum.PARAM_NULL;
        }
        boolean success = this.aiViewHlwFjxxRepository.deleteFjxxByFjid(fjid);
        if (StringUtils.isNotBlank((CharSequence)hlwFjxxOperateDto.getFilepath()) && (deleteFile = new File(hlwFjxxOperateDto.getFilepath())).exists()) {
            boolean mkdirs = deleteFile.mkdirs();
            log.debug("\u5220\u9664mkdirs:{}", (Object)mkdirs);
        }
        return ErrorEnum.SUCCESS;
    }

    @Override
    public IError insertFjxx(HlwFjxxSaveDto hlwFjxxSaveDto) {
        HlwFjxxModel hlwFjxxModel = this.aiViewHlwFjxxRepository.insertFjxx(hlwFjxxSaveDto);
        return Objects.isNull(hlwFjxxModel) ? ErrorEnum.SERVICE_ERROR : ErrorEnum.SUCCESS;
    }

    @Override
    public HlwFjxmModel createFjxm(MultiPartModel multiPartModel) {
        String time = String.valueOf(System.currentTimeMillis());
        byte[] data = multiPartModel.getData();
        multiPartModel.setData(null);
        log.info("{}: \u5f00\u59cb createFjxm( String time:{}, String multiPartModel:{})", new Object[]{multiPartModel.getAppId(), time, JSON.toJSONString((Object)multiPartModel)});
        multiPartModel.setData(data);
        FjxxQuery fjxxQuery = new FjxxQuery();
        fjxxQuery.setSqid(multiPartModel.getAppId());
        fjxxQuery.setFjlx(multiPartModel.getTag());
        List<HlwFjxmModel> hlwFjxmModelList = this.aiViewHlwFjxmRepository.queryFjxm(fjxxQuery);
        HlwFjxmModel hlwFjxmModel = null;
        if (CollectionUtils.isNotEmpty(hlwFjxmModelList)) {
            hlwFjxmModel = hlwFjxmModelList.get(0);
            log.info("{}: \u6267\u884c createFjxm \u76ee\u5f55\u5df2\u5b58\u5728( String time:{})", (Object)multiPartModel.getAppId(), (Object)time);
        } else {
            HlwFjxmSaveDto hlwFjxmSaveDto = new HlwFjxmSaveDto();
            hlwFjxmSaveDto.setXmid(multiPartModel.getParentFolderNodeId());
            hlwFjxmSaveDto.setSqid(multiPartModel.getAppId());
            hlwFjxmSaveDto.setFjlx(multiPartModel.getTag());
            AiXtZdQuery aiXtZdQuery = new AiXtZdQuery();
            aiXtZdQuery.setZdlx(ZdlxEnum.FJLX);
            aiXtZdQuery.setZddm(multiPartModel.getTag());
            AiXtZd fjlxZd = this.zdService.getXtZd(aiXtZdQuery);
            if (!Objects.isNull(fjlxZd)) {
                hlwFjxmSaveDto.setFjlxmc(fjlxZd.getMc());
            }
            hlwFjxmModel = this.aiViewHlwFjxmRepository.saveFjxm(hlwFjxmSaveDto);
            log.info("{}: \u6267\u884c createFjxm \u76ee\u5f55\u9700\u8981\u65b0\u5efa ( String time:{})", (Object)multiPartModel.getAppId(), (Object)time);
        }
        log.info("{}: \u7ed3\u675f createFjxm ( String time:{}, String hlwFjxmModel:{})", new Object[]{multiPartModel.getAppId(), time, JSON.toJSONString((Object)hlwFjxmModel)});
        return hlwFjxmModel;
    }
}

