/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.service.storage.application.OlcommonFjxxModelService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.service.storage.domain.model.HlwFjxmModel;
import cn.gtmap.ai.core.service.storage.domain.repository.AiViewHlwFjxmRepository;
import cn.gtmap.ai.core.service.storage.domain.repository.AiViewHlwFjxxRepository;
import cn.gtmap.ai.core.service.storage.dto.FjxxQuery;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.HlwFjxmModelConverter;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.HlwFjxxModelConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OlcommonFjxxModelServiceImpl
implements OlcommonFjxxModelService {
    @Autowired
    private AiViewHlwFjxmRepository aiViewHlwFjxmRepository;
    @Autowired
    private AiViewHlwFjxxRepository aiViewHlwFjxxRepository;
    @Value(value="${hlw.file.path:}")
    private String hlwFilePath;

    @Override
    public List<StorageModel> queryFjxm(MultiPartModel multiPartModel) {
        FjxxQuery fjxxQuery = HlwFjxmModelConverter.INSTANCE.multiPartModelToQuery(multiPartModel);
        if (StringUtils.isNotBlank((CharSequence)fjxxQuery.getSqid()) || StringUtils.isNotBlank((CharSequence)fjxxQuery.getXmid())) {
            List<StorageModel> storageModelList = HlwFjxmModelConverter.INSTANCE.fjxmModelToStorageModellList(this.aiViewHlwFjxmRepository.queryFjxm(fjxxQuery));
            if (CollectionUtils.isNotEmpty(storageModelList)) {
                for (StorageModel storageModel : storageModelList) {
                    fjxxQuery = new FjxxQuery();
                    fjxxQuery.setXmid(storageModel.getId());
                    List<StorageModel> fjxxList = HlwFjxxModelConverter.INSTANCE.fjxxModelToStorageModelList(this.aiViewHlwFjxxRepository.queryFjxx(fjxxQuery));
                    if (!CollectionUtils.isNotEmpty(fjxxList)) continue;
                    for (StorageModel fjxx : fjxxList) {
                        File file;
                        String path = this.hlwFilePath + fjxx.getPath();
                        if (!StringUtils.endsWith((CharSequence)path, (CharSequence)fjxx.getName())) {
                            path = path + File.separator + fjxx.getName();
                        }
                        if (!(file = new File(path)).exists()) continue;
                        fjxx.setFileSize(file.length() / 1024L);
                    }
                    storageModel.setChildren(fjxxList);
                }
            }
            return storageModelList;
        }
        throw new ParamException((IError)ErrorEnum.PARAM_NULL, "currentNodeId\u4e0eparentFolderNodeId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
    }

    @Override
    public List<StorageModel> queryFjxx(MultiPartModel multiPartModel) {
        FjxxQuery fjxxQuery = HlwFjxmModelConverter.INSTANCE.multiPartModelToQuery(multiPartModel);
        if (StringUtils.isBlank((CharSequence)fjxxQuery.getXmid())) {
            throw new ParamException((IError)ErrorEnum.PARAM_NULL, "currentNodeId\u4e0eparentFolderNodeId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        List<StorageModel> fjxxList = HlwFjxxModelConverter.INSTANCE.fjxxModelToStorageModelList(this.aiViewHlwFjxxRepository.queryFjxx(fjxxQuery));
        return fjxxList;
    }

    @Override
    public StorageModel getFjxxByFjid(String fjid) {
        return HlwFjxxModelConverter.INSTANCE.fjxxModelToStorageModel(this.aiViewHlwFjxxRepository.getFjxxByFjid(fjid));
    }

    @Override
    public HlwFjxmModel getFjxmByXmid(String xmid) {
        return this.aiViewHlwFjxmRepository.getFjxmByXmid(xmid);
    }

    @Override
    public void showFile(MultiPartModel multiPartModel, HttpServletResponse httpServletResponse) {
        FjxxQuery fjxxQuery = HlwFjxmModelConverter.INSTANCE.multiPartModelToQuery(multiPartModel);
        List<StorageModel> fjxxList = HlwFjxxModelConverter.INSTANCE.fjxxModelToStorageModelList(this.aiViewHlwFjxxRepository.queryFjxx(fjxxQuery));
        if (CollectionUtils.isNotEmpty(fjxxList)) {
            File file;
            StorageModel storageModel = fjxxList.get(0);
            String path = this.hlwFilePath + (this.hlwFilePath.endsWith(File.separator) || "/".equals(this.hlwFilePath) ? "" : File.separator) + storageModel.getPath();
            if (!StringUtils.endsWith((CharSequence)path, (CharSequence)storageModel.getName())) {
                path = path + File.separator + storageModel.getName();
            }
            if ((file = new File(path)).exists()) {
                this.fileOutput(path, storageModel, httpServletResponse);
            }
        }
    }

    private void fileOutput(String path, StorageModel storageModel, HttpServletResponse httpServletResponse) {
        File file = new File(path);
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(path);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            httpServletResponse.setContentType(contentType);
        } else {
            httpServletResponse.setContentType("image/jpeg;image/png;");
        }
        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(file);){
            String filename = URLEncoder.encode(storageModel.getName(), "UTF-8");
            httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + filename);
            byte[] buffer = new byte[1024];
            int i = -1;
            while ((i = ((InputStream)fileInputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, i);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

