/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.service.dto.MultipartDto;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.GtcMultiPartConvert;
import cn.gtmap.ai.core.utils.bean.BeanConvertUtil;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="gtcStorageServiceImpl")
public class GtcStorageServiceImpl
implements StorageService {
    @Override
    public StorageModel uploadFile(MultiPartModel multiPartModel) {
        if (StringUtils.isBlank((CharSequence)multiPartModel.getParentFolderNodeId()) && CollectionUtils.isEmpty(multiPartModel.getFolderNameList()) || Objects.isNull(multiPartModel.getData())) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        MultipartDto multipartDto = GtcMultiPartConvert.INSTANCE.toStorageModel(multiPartModel);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{multipartDto.getClientId(), multipartDto.getOriginalFilename(), multipartDto.getSpaceCode()})) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        if (CollectionUtils.isNotEmpty(multiPartModel.getFolderNameList())) {
            List<String> nodeNameList = BeanConvertUtil.copyList(multiPartModel.getFolderNameList(), String.class);
            String nodeId = this.createFolderNode(nodeNameList, multipartDto.getClientId(), multipartDto.getOwner(), multipartDto.getSpaceCode(), multipartDto.getNodeId());
            multipartDto.setNodeId(nodeId);
        }
        return null;
    }

    @Override
    public StorageModel createFolder(MultiPartModel multiPartModel) {
        if (StringUtils.isBlank((CharSequence)multiPartModel.getParentFolderNodeId()) && CollectionUtils.isEmpty(multiPartModel.getFolderNameList())) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        MultipartDto multipartDto = GtcMultiPartConvert.INSTANCE.toStorageModel(multiPartModel);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{multipartDto.getClientId(), multipartDto.getSpaceCode()})) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        if (CollectionUtils.isNotEmpty(multiPartModel.getFolderNameList())) {
            List<String> nodeNameList = BeanConvertUtil.copyList(multiPartModel.getFolderNameList(), String.class);
            String nodeId = this.createFolderNode(nodeNameList, multipartDto.getClientId(), multipartDto.getOwner(), multipartDto.getSpaceCode(), multipartDto.getNodeId());
            multipartDto.setNodeId(nodeId);
        }
        return null;
    }

    @Override
    public MultiPartModel downLoadNode(MultiPartModel multiPartModel) {
        return null;
    }

    private String createFolderNode(List<String> nodeNameList, String clientid, String owner, String spaceCode, String nodeId) {
        if (CollectionUtils.isEmpty(nodeNameList)) {
            return nodeId;
        }
        nodeNameList.remove(0);
        if (CollectionUtils.isNotEmpty(nodeNameList)) {
            nodeId = this.createFolderNode(nodeNameList, clientid, owner, spaceCode, nodeId);
        }
        return nodeId;
    }

    @Override
    public List<StorageModel> queryFjxx(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public void showFile(MultiPartModel multiPartModel, HttpServletResponse httpServletResponse) {
    }
}

