/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.app.application.impl;

import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.exception.PzxException;
import cn.gtmap.ai.core.service.app.domain.bo.spb.TokenByTickectBO;
import cn.gtmap.ai.core.service.app.domain.bo.spb.UserByTokenBO;
import cn.gtmap.ai.core.service.app.domain.dto.sfb.SfbVerifyTicketResponseDto;
import cn.gtmap.ai.core.service.app.domain.dto.sfb.SfbVerifyTokenResponseDto;
import cn.gtmap.ai.core.service.auth.application.convert.UserInfoConverter;
import cn.gtmap.ai.core.service.auth.domain.model.login.AppLoginBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.token.application.AiXtJkglModelService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.encryption.sm4.Sm4Util;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.common.util.UUIDGenerator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfbAppServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(SfbAppServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AiXtJkglModelService aiXtJkglModelService;
    @Autowired
    private HttpUtil httpUtil;
    @Autowired
    private ComponentConstants componentConstants;
    private static final String SFB_VERIFY_TICKET_JKGJZ = "sfb.app.verify.ticket.url";
    private static final String SFB_VERIFY_TOKEN_JKGJZ = "sfb.app.verify.token.url";

    public LoginResultDto getToken(AppLoginBaseDto appLoginBaseDto) {
        LoginResultDto loginResultDto = new LoginResultDto();
        if (StringUtils.isBlank((CharSequence)appLoginBaseDto.getTicket())) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm(this.componentConstants.getQydm());
        jkglQuery.setJkgjz(SFB_VERIFY_TICKET_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
            throw new PzxException("\u82cf\u670d\u529eticket\u83b7\u53d6token\u63a5\u53e3: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
        }
        JSONObject qtjrcs = jkglModel.getJrcs();
        if (Objects.isNull(qtjrcs) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qtjrcs.getString("key"), qtjrcs.getString("secret")})) {
            throw new PzxException("\u82cf\u670d\u529eticket\u83b7\u53d6token\u63a5\u53e3: " + jkglQuery.getJkgjz() + " qtjrcs \u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5secret \u548c key !");
        }
        TokenByTickectBO tokenByTickectBO = new TokenByTickectBO();
        tokenByTickectBO.setKey(Sm2lib.decode(qtjrcs.getString("key")));
        tokenByTickectBO.setSecret(Sm2lib.decode(qtjrcs.getString("secret")));
        tokenByTickectBO.setTicket(appLoginBaseDto.getTicket());
        String requestBh = UUIDGenerator.generate();
        SfbVerifyTicketResponseDto sfbVerifyTicketResponseDto = this.httpUtil.getGetData(JSONObject.parseObject((String)JSON.toJSONString((Object)tokenByTickectBO)), jkglModel.getJkdz(), SfbVerifyTicketResponseDto.class, jkglModel.getJkgjz(), requestBh, null);
        if (!Objects.isNull(sfbVerifyTicketResponseDto) && sfbVerifyTicketResponseDto.isSuccess()) {
            jkglQuery.setQydm(this.componentConstants.getQydm());
            jkglQuery.setJkgjz(SFB_VERIFY_TOKEN_JKGJZ);
            jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
            if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
                throw new PzxException("\u82cf\u670d\u529eticket\u83b7\u53d6token\u63a5\u53e3: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
            }
            qtjrcs = jkglModel.getJrcs();
            if (Objects.isNull(qtjrcs) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qtjrcs.getString("key"), qtjrcs.getString("secret")})) {
                throw new PzxException("\u82cf\u670d\u529eticket\u83b7\u53d6token\u63a5\u53e3: " + jkglQuery.getJkgjz() + " qtjrcs \u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5secret \u548c key !");
            }
            UserByTokenBO userByTokenBO = new UserByTokenBO();
            userByTokenBO.setKey(Sm2lib.decode(qtjrcs.getString("key")));
            userByTokenBO.setSecret(Sm2lib.decode(qtjrcs.getString("secret")));
            userByTokenBO.setToken(sfbVerifyTicketResponseDto.getToken());
            SfbVerifyTokenResponseDto sfbVerifyTokenResponseDto = this.httpUtil.getGetData(JSONObject.parseObject((String)JSON.toJSONString((Object)userByTokenBO)), jkglModel.getJkdz(), SfbVerifyTokenResponseDto.class, jkglModel.getJkgjz(), requestBh, null);
            if (!Objects.isNull(sfbVerifyTokenResponseDto) && sfbVerifyTokenResponseDto.isSuccess()) {
                UserInfoDto userInfoDto = UserInfoConverter.INSTANCE.sfbUserToUserInfoDto(sfbVerifyTokenResponseDto.getUserdetail());
                String token = Sm4Util.encryptEcb(sfbVerifyTicketResponseDto.getToken());
                DesensitizedUtil.desensitizeObj(userInfoDto);
                loginResultDto.setToken(token);
                loginResultDto.setError(ErrorEnum.SUCCESS);
                loginResultDto.setExpiresIn(5400L);
                loginResultDto.setUserInfoDto(userInfoDto);
                String userRedisKey = UserRedisContants.getUserinfoByTokenPrefixRedisKey(token);
                this.redisUtils.addStringValue(userRedisKey, JSON.toJSONString((Object)loginResultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto.getExpiresIn());
                this.redisUtils.addStringValue(UserRedisContants.getRestauthUserinfoByClientidPrefixRedisKey(userInfoDto.getUserId()), JSON.toJSONString((Object)loginResultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto.getExpiresIn());
            } else {
                loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
        } else {
            loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
        }
        return loginResultDto;
    }
}

