/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.app.application.impl;

import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.BoolenEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.MyYcAppFaceDto;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.MyYcAppUserDto;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.MyYcDataDto;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.MyYcFaceDataDto;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.MyYcHeadDto;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.ResponseMyYcFaceDto;
import cn.gtmap.ai.core.service.auth.application.convert.UserInfoConverter;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.token.application.AiXtJkglModelService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import cn.gtmap.ai.core.utils.time.DateUtils;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.config.AppConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class MyycAppServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(MyycAppServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AiXtJkglModelService aiXtJkglModelService;
    @Autowired
    private HttpUtil httpUtil;
    @Autowired
    private ComponentConstants componentConstants;
    @Value(value="${myyc.app.service.ip:}")
    private String myYcAppIp;
    @Value(value="${myyc.app.service.appid:68d19a4142d445f29fc912e8ee624257}")
    private String myYcAppAppid;
    @Value(value="${myyc.app.service.appkey:f8e0720dc1d840338aa52acc4ce87fea}")
    private String myYcAppAppkey;
    private static final String INIT_CODE_URL_JKGJZ = "myyc.app.service.initCodeUrl";
    private static final String AUTH_CODE_URL_JKGJZ = "myyc.app.service.authCodeUrl";
    private static final String ACCESS_TOKEN_URL_JKGJZ = "myyc.app.service.accessTokenUrl";
    private static final String USER_ACCESS_TOKEN_URL_JKGJZ = "myyc.app.service.userAccessTokenUrl";
    private static final String USER_INFO_URL_JKGJZ = "myyc.app.service.userInfoUrl";
    private static final String HANDLE_REPORT_JKGJZ = "myyc.app.service.handleReport";
    private static final String FACE_BASE64_JKGJZ = "myyc.app.service.handleReport";
    private static final String WDYC_SUCCESS_CODE = "200";

    public Map getMyYcAppInitCode() {
        HashMap map = new HashMap(16);
        String code = "28001";
        String timestamp = String.valueOf(System.currentTimeMillis());
        String randomSeries = this.getRandomSeries();
        String cipherText = this.getCipherText(timestamp, randomSeries);
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("timestamp", timestamp);
        param.put("randomSeries", randomSeries);
        param.put("cipherText", cipherText);
        param.put("appId", this.myYcAppAppid);
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm(this.componentConstants.getQydm());
        jkglQuery.setJkgjz(INIT_CODE_URL_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        Map result = this.httpUtil.getPostData(JSON.toJSONString(param), jkglModel.getJkdz(), Map.class, INIT_CODE_URL_JKGJZ, null);
        if (StringUtils.equals((CharSequence)WDYC_SUCCESS_CODE, (CharSequence)CommonUtil.formatEmptyValue(result.get("code")))) {
            map.put("initCode", ((Map)result.get("data")).get("initCode"));
            map.put("appId", this.myYcAppAppid);
            code = ErrorEnum.SUCCESS.getCode();
        }
        map.put("code", code);
        return map;
    }

    public Map getMyYcAppAuthCode() {
        HashMap map = new HashMap(16);
        String code = "28002";
        String timestamp = String.valueOf(System.currentTimeMillis());
        String randomSeries = this.getRandomSeries();
        String cipherText = this.getCipherText(timestamp, randomSeries);
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("timestamp", timestamp);
        param.put("randomSeries", randomSeries);
        param.put("cipherText", cipherText);
        param.put("appId", this.myYcAppAppid);
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm(this.componentConstants.getQydm());
        jkglQuery.setJkgjz(AUTH_CODE_URL_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        Map result = this.httpUtil.getPostData(JSON.toJSONString(param), jkglModel.getJkdz(), Map.class, AUTH_CODE_URL_JKGJZ, null);
        if (StringUtils.equals((CharSequence)WDYC_SUCCESS_CODE, (CharSequence)CommonUtil.formatEmptyValue(result.get("code")))) {
            map.put("authCode", ((Map)result.get("data")).get("authCode"));
            code = ErrorEnum.SUCCESS.getCode();
        }
        map.put("code", code);
        return map;
    }

    public Map getMyYcAppAccessToken() {
        Map map = this.getMyYcAppAuthCode();
        String code = CommonUtil.formatEmptyValue(map.get("code"));
        String authCode = CommonUtil.formatEmptyValue(map.get("authCode"));
        if (StringUtils.isNotBlank((CharSequence)authCode) && StringUtils.equals((CharSequence)ErrorEnum.SUCCESS.getCode(), (CharSequence)code)) {
            HashMap<String, String> param = new HashMap<String, String>(16);
            param.put("appId", this.myYcAppAppid);
            param.put("authCode", authCode);
            JkglQuery jkglQuery = new JkglQuery();
            jkglQuery.setQydm(this.componentConstants.getQydm());
            jkglQuery.setJkgjz(ACCESS_TOKEN_URL_JKGJZ);
            JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
            Map result = this.httpUtil.getPostData(JSON.toJSONString(param), jkglModel.getJkdz(), Map.class, ACCESS_TOKEN_URL_JKGJZ, null);
            if (StringUtils.equals((CharSequence)WDYC_SUCCESS_CODE, (CharSequence)CommonUtil.formatEmptyValue(result.get("code")))) {
                map.put("accessToken", ((Map)result.get("data")).get("accessToken"));
                code = ErrorEnum.SUCCESS.getCode();
            } else {
                code = "28003";
            }
        }
        map.put("code", code);
        return map;
    }

    public Map getMyYcAppUserAccessToken(String requestCode) {
        HashMap result = new HashMap(16);
        String code = ErrorEnum.PARAM_NULL.getCode();
        if (StringUtils.isNotBlank((CharSequence)requestCode)) {
            Map accessTokenMap = this.getMyYcAppAccessToken();
            code = CommonUtil.formatEmptyValue(accessTokenMap.get("code"));
            String accessToken = CommonUtil.formatEmptyValue(accessTokenMap.get("accessToken"));
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                HashMap<String, String> param = new HashMap<String, String>(16);
                param.put("appId", this.myYcAppAppid);
                param.put("requestCode", requestCode);
                param.put("accessToken", accessToken);
                JkglQuery jkglQuery = new JkglQuery();
                jkglQuery.setQydm(this.componentConstants.getQydm());
                jkglQuery.setJkgjz(USER_ACCESS_TOKEN_URL_JKGJZ);
                JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                Map resultMap = this.httpUtil.getPostData(JSON.toJSONString(param), jkglModel.getJkdz(), Map.class, USER_ACCESS_TOKEN_URL_JKGJZ, null);
                if (StringUtils.equals((CharSequence)WDYC_SUCCESS_CODE, (CharSequence)CommonUtil.formatEmptyValue(resultMap.get("code"))) && StringUtils.equals((CharSequence)BoolenEnum.TRUE.getMsg(), (CharSequence)CommonUtil.formatEmptyValue(((Map)resultMap.get("data")).get("verifyResult")))) {
                    result.put("userAccessToken", ((Map)resultMap.get("data")).get("userAccessToken"));
                    code = ErrorEnum.SUCCESS.getCode();
                } else {
                    code = "28004";
                }
                log.info(JSON.toJSONString((Object)resultMap));
            }
        }
        result.put("code", code);
        return result;
    }

    public LoginResultDto getMyYcAppUserInfo(String requestCode) {
        LoginResultDto loginResultDto = new LoginResultDto();
        String code = ErrorEnum.PARAM_NULL.getCode();
        if (StringUtils.isNotBlank((CharSequence)requestCode)) {
            log.info("\u83b7\u53d6\u7528\u6237\u8c03\u7528\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtils.systemDateStr());
            Map userAccessTokenMap = this.getMyYcAppUserAccessToken(requestCode);
            if (StringUtils.equals((CharSequence)ErrorEnum.SUCCESS.getCode(), (CharSequence)CommonUtil.formatEmptyValue(userAccessTokenMap.get("code")))) {
                String userAccessToken = CommonUtil.formatEmptyValue(userAccessTokenMap.get("userAccessToken"));
                if (StringUtils.isNotBlank((CharSequence)userAccessToken)) {
                    HashMap<String, String> param = new HashMap<String, String>(16);
                    param.put("userAccessToken", userAccessToken);
                    JkglQuery jkglQuery = new JkglQuery();
                    jkglQuery.setQydm(this.componentConstants.getQydm());
                    jkglQuery.setJkgjz(USER_INFO_URL_JKGJZ);
                    JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                    JSONObject userObject = this.httpUtil.getPostData(JSON.toJSONString(param), jkglModel.getJkdz(), JSONObject.class, USER_INFO_URL_JKGJZ, null);
                    log.info("\u7528\u6237\u8eab\u4efd\u4fe1\u606f\uff08userinfo\uff09\uff1a" + JSON.toJSONString((Object)userObject));
                    log.info("\u83b7\u53d6\u7528\u6237\u8c03\u7528\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtils.systemDateStr());
                    if (!Objects.isNull(userObject) && StringUtils.equals((CharSequence)WDYC_SUCCESS_CODE, (CharSequence)userObject.getString("code"))) {
                        HttpServletRequest request;
                        MyYcAppUserDto myYcAppUser = (MyYcAppUserDto)userObject.getObject("data", MyYcAppUserDto.class);
                        code = this.checkMyYcAppUserInfoData(myYcAppUser);
                        if (StringUtils.equals((CharSequence)code, (CharSequence)ErrorEnum.SUCCESS.getCode()) && Objects.nonNull(request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest())) {
                            String userRedisKey = UserRedisContants.getUserinfoByTokenPrefixRedisKey(userAccessToken);
                            UserInfoDto userInfoDto = UserInfoConverter.INSTANCE.myycUserToUserInfoDto(myYcAppUser);
                            DesensitizedUtil.desensitizeObj(userInfoDto);
                            loginResultDto.setToken(userAccessToken);
                            loginResultDto.setError(ErrorEnum.SUCCESS);
                            loginResultDto.setExpiresIn(5400L);
                            loginResultDto.setUserInfoDto(userInfoDto);
                            this.redisUtils.addStringValue(userRedisKey, JSON.toJSONString((Object)loginResultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto.getExpiresIn());
                            this.redisUtils.addStringValue(UserRedisContants.getRestauthUserinfoByClientidPrefixRedisKey(userInfoDto.getUserId()), JSON.toJSONString((Object)loginResultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto.getExpiresIn());
                        }
                    } else {
                        loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
                    }
                }
            } else {
                loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
        }
        return loginResultDto;
    }

    public MyYcFaceDataDto getFaceBase64(Map map) {
        ResponseMyYcFaceDto userObject;
        MyYcFaceDataDto myYcFaceData = new MyYcFaceDataDto();
        String faseUrl = AppConfig.getPlaceholderValue((String)AppConfig.getProperty((String)"myface.credentialValid"));
        String phone = CommonUtil.formatEmptyValue(map.get("phone"));
        String appId = CommonUtil.formatEmptyValue(map.get("appId"));
        String ecodephone = Base64.encodeBase64String((byte[])phone.getBytes());
        MyYcAppFaceDto myYcAppFace = new MyYcAppFaceDto();
        MyYcHeadDto head = new MyYcHeadDto();
        MyYcDataDto data = new MyYcDataDto();
        HashMap<String, String> hashmap = new HashMap<String, String>(16);
        HashMap<String, String> header = new HashMap<String, String>(16);
        hashmap.put("appId", appId);
        hashmap.put("mobileNo", ecodephone);
        data.setAppId(appId);
        myYcAppFace.setData(hashmap);
        myYcAppFace.setHeader(head);
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm(this.componentConstants.getQydm());
        jkglQuery.setJkgjz(ACCESS_TOKEN_URL_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        String result = this.httpUtil.sendYcpostData(JSON.toJSONString(hashmap), null, faseUrl.trim(), header);
        if (JSONValidator.from((String)result).validate() && !Objects.isNull(userObject = (ResponseMyYcFaceDto)JSON.parseObject((String)result, ResponseMyYcFaceDto.class)) && StringUtils.equals((CharSequence)WDYC_SUCCESS_CODE, (CharSequence)userObject.getCode())) {
            myYcFaceData = userObject.getData();
        }
        return myYcFaceData;
    }

    public String getRandomSeries() {
        String randomStr = "";
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            randomStr = randomStr + String.valueOf(random.nextInt(9));
        }
        if (randomStr.startsWith("0")) {
            randomStr.replaceFirst("0", "1");
        }
        return randomStr;
    }

    public String getCipherText(String timestamp, String randomSeries) {
        StringBuilder builder = new StringBuilder();
        builder.append("appId").append(this.myYcAppAppid).append("appKey").append(this.myYcAppAppkey).append("randomSeries").append(randomSeries).append("timestamp").append(timestamp);
        String cipherText = DigestUtils.md5Hex((String)builder.toString());
        return cipherText;
    }

    private String checkMyYcAppUserInfoData(MyYcAppUserDto myYcAppUser) {
        String code = ErrorEnum.SUCCESS.getCode();
        if (!Objects.isNull(myYcAppUser)) {
            if (StringUtils.isBlank((CharSequence)myYcAppUser.getMobileNo())) {
                code = ErrorEnum.PHONENULL.getCode();
            } else if (StringUtils.isBlank((CharSequence)myYcAppUser.getOpenId())) {
                code = ErrorEnum.REQUSERIDORBEOPERATEUSERIDNULL.getCode();
            }
        }
        return code;
    }
}

