/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service;

import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.enums.LoginAppEnum;
import cn.gtmap.ai.core.service.auth.application.AppAuthService;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.log.application.LogService;
import cn.gtmap.ai.core.service.sfzdzzz.application.SfzDzzzService;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.user.application.UserService;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFactory {
    @Autowired
    ComponentConstants componentConstants;
    @Autowired
    private Map<String, StorageService> storageServiceMap;
    @Autowired
    private Map<String, AuthService> authServiceMap;
    @Autowired
    private Map<String, UserService> userServiceMap;
    @Autowired
    private Map<String, AppAuthService> appAuthServiceMap;
    @Autowired
    private Map<String, SfzDzzzService> sfzDzzzServiceMap;
    @Autowired
    private Map<String, LogService> logServiceMap;
    private static final String STORAGE_SERVICE_SUFIX = "StorageServiceImpl";
    private static final String LOG_SERVICE_SUFIX = "LogServiceImpl";
    private static final String AUTH_SERVICE_SUFIX = "AuthServiceImpl";
    private static final String USER_SERVICE_SUFIX = "UserServiceImpl";
    private static final String APP_AUTH_SERVICE_SUFIX = "AppAuthServiceImpl";
    private static final String SFZDZZZ_SERVICE_SUFIX = "DzzzServiceImpl";

    public StorageService getStorageService() {
        StorageService service = (StorageService)MapUtils.getObject(this.storageServiceMap, (Object)(this.componentConstants.getServiceKey() + STORAGE_SERVICE_SUFIX));
        return service;
    }

    public StorageService getStorageService(String serviceKey) {
        StorageService service = (StorageService)MapUtils.getObject(this.storageServiceMap, (Object)(serviceKey + STORAGE_SERVICE_SUFIX));
        return service;
    }

    public AuthService getAuthService() {
        AuthService service = (AuthService)MapUtils.getObject(this.authServiceMap, (Object)(this.componentConstants.getAuthServiceKey() + AUTH_SERVICE_SUFIX));
        return service;
    }

    public UserService getUserService() {
        UserService service = (UserService)MapUtils.getObject(this.userServiceMap, (Object)(this.componentConstants.getAuthServiceKey() + USER_SERVICE_SUFIX));
        if (Objects.isNull(service)) {
            service = (UserService)MapUtils.getObject(this.userServiceMap, (Object)USER_SERVICE_SUFIX);
        }
        return service;
    }

    public AppAuthService getAppAuthService(LoginAppEnum loginAppEnum) {
        AppAuthService service = (AppAuthService)MapUtils.getObject(this.appAuthServiceMap, (Object)(loginAppEnum.getLoginAppType() + APP_AUTH_SERVICE_SUFIX));
        return service;
    }

    public SfzDzzzService getSfzDzzzService(JkglModel jkglModel) {
        SfzDzzzService service = (SfzDzzzService)MapUtils.getObject(this.sfzDzzzServiceMap, (Object)(jkglModel.getYydm() + SFZDZZZ_SERVICE_SUFIX));
        return service;
    }

    public LogService getLogService() {
        LogService service = (LogService)MapUtils.getObject(this.logServiceMap, (Object)(this.componentConstants.getServiceKey() + LOG_SERVICE_SUFIX));
        if (Objects.isNull(service)) {
            service = (LogService)MapUtils.getObject(this.logServiceMap, (Object)LOG_SERVICE_SUFIX);
        }
        return service;
    }
}

