/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.login.apps;

import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.app.application.impl.SfbAppServiceImpl;
import cn.gtmap.ai.core.service.auth.domain.model.login.AppLoginBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/sfb/v1"})
public class SfbController {
    @Autowired
    SfbAppServiceImpl sfbAppService;
    @Autowired
    RedisUtils redisUtils;

    @ResponseBody
    @RequestMapping(value={"/login"})
    public ReturnResult login(@RequestBody AppLoginBaseDto appLoginBaseDto, HttpServletRequest request, HttpServletResponse response) {
        LoginResultDto loginResultDto = null;
        IError iError = ErrorEnum.SERVICE_ERROR;
        String redisKey = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)appLoginBaseDto.getTicket())) {
            loginResultDto = this.sfbAppService.getToken(appLoginBaseDto);
            if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
                iError = loginResultDto.getError();
                loginResultDto.setError(null);
            }
        } else {
            iError = ErrorEnum.PARAM_NULL;
        }
        ReturnResult returnResult = ReturnResult.error(iError);
        returnResult.setData(loginResultDto);
        return returnResult;
    }

    @RequestMapping(value={"/testlogin"})
    @ResponseBody
    public ReturnResult test(AppLoginBaseDto appLoginBaseDto, HttpServletRequest request, HttpServletResponse response) {
        return this.login(appLoginBaseDto, request, response);
    }
}

