/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.exception.handler;

import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.exception.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Configuration
@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ReturnResult<String> handleGlobalException(Exception ex) {
        log.error("\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5:", (Throwable)ex);
        return ReturnResult.error();
    }

    @ResponseBody
    @ExceptionHandler(value={BizException.class})
    public ReturnResult<String> handleBaseException(BizException ex) {
        log.error("\u901a\u7528\u4e1a\u52a1\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5:", (Throwable)ex);
        return ReturnResult.error(ex.getIError().getCode(), ex.getIError().getMsg());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public ReturnResult<String> handleParamException(ParamException ex) {
        log.error("\u53c2\u6570\u4e1a\u52a1\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5:", (Throwable)ex);
        return ReturnResult.error(ex.getIError().getCode(), ex.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={TokenException.class})
    public ReturnResult<String> handleBaseException(TokenException ex) {
        log.error("token\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5:", (Throwable)ex);
        return ReturnResult.error(ex.getIError());
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ReturnResult<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5:", (Throwable)e);
        String message = e.getBindingResult().getFieldError().getDefaultMessage();
        return ReturnResult.error(ErrorEnum.CHECK_FAIL.getCode(), message);
    }
}

