/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.config;

import cn.gtmap.ai.core.annotation.desensitization.ItemDesensitize;
import cn.gtmap.ai.core.annotation.desensitization.ObjDesensitize;
import cn.gtmap.ai.core.annotation.encrypt.ItemEncrypt;
import cn.gtmap.ai.core.annotation.encrypt.ObjEncrypt;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FieldMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(FieldMetaObjectHandler.class);
    private static final String ID = "id";
    private static final String CREATE_TIME = "createTime";
    private static final String UPDATE_TIME = "updateTime";
    private static final String UPDATE_BY = "updateUser";
    private static final String CREATE_BY = "createUser";

    public void insertFill(MetaObject metaObject) {
        ObjEncrypt objEncryptAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(ObjEncrypt.class);
        ObjDesensitize objDesensitizeAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(ObjDesensitize.class);
        if (Objects.isNull(objEncryptAnnotation) && Objects.isNull(objDesensitizeAnnotation)) {
            return;
        }
        Object obj = metaObject.getOriginalObject();
        Field[] fields = metaObject.getOriginalObject().getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            ItemEncrypt itemEncryptAnnotation = field.getAnnotation(ItemEncrypt.class);
            ItemDesensitize itemDesensitizeAnnotation = field.getAnnotation(ItemDesensitize.class);
            try {
                String objValue;
                field.setAccessible(true);
                if (!Objects.isNull(itemDesensitizeAnnotation) && StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) {
                    this.setFieldValByName(field.getName(), DesensitizedUtil.stringDesensitize(objValue, itemDesensitizeAnnotation.type()), metaObject);
                }
                if (Objects.isNull(itemEncryptAnnotation) || !StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) continue;
                this.setFieldValByName(field.getName(), EncryptUtil.encryptStr(objValue, itemEncryptAnnotation.encryptType()), metaObject);
            }
            catch (Exception e) {
                log.error(" \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", metaObject.getOriginalObject().getClass(), (Object)field.getName());
            }
        }
        this.setFieldValByName(ID, UUID.randomUUID().toString().replace("-", "").toUpperCase(), metaObject);
        this.strictInsertFill(metaObject, CREATE_TIME, Date.class, new Date(System.currentTimeMillis()));
        this.setFieldValByName(CREATE_BY, "admin", metaObject);
    }

    public void updateFill(MetaObject metaObject) {
        ObjEncrypt objEncryptAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(ObjEncrypt.class);
        ObjDesensitize objDesensitizeAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(ObjDesensitize.class);
        if (Objects.isNull(objEncryptAnnotation) && Objects.isNull(objDesensitizeAnnotation)) {
            return;
        }
        Object obj = metaObject.getOriginalObject();
        Field[] fields = metaObject.getOriginalObject().getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            ItemEncrypt itemEncryptAnnotation = field.getAnnotation(ItemEncrypt.class);
            ItemDesensitize itemDesensitizeAnnotation = field.getAnnotation(ItemDesensitize.class);
            try {
                String objValue;
                field.setAccessible(true);
                if (!Objects.isNull(itemDesensitizeAnnotation) && StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) {
                    this.setFieldValByName(field.getName(), DesensitizedUtil.stringDesensitize(objValue, itemDesensitizeAnnotation.type()), metaObject);
                }
                if (Objects.isNull(itemEncryptAnnotation) || !StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) continue;
                this.setFieldValByName(field.getName(), EncryptUtil.encryptStr(objValue, itemEncryptAnnotation.encryptType()), metaObject);
            }
            catch (Exception e) {
                log.error(" \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", metaObject.getOriginalObject().getClass(), (Object)field.getName());
            }
        }
        this.strictInsertFill(metaObject, UPDATE_TIME, Date.class, new Date(System.currentTimeMillis()));
        this.setFieldValByName(CREATE_BY, "admin", metaObject);
    }

    public TableInfo findTableInfo(MetaObject metaObject) {
        return super.findTableInfo(metaObject);
    }
}

