/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.base;

import cn.gtmap.ai.core.utils.bean.BeanConvertUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;

public class PageInfo<T> {
    private Integer pageNum;
    private Integer pageSize;
    private String sidx;
    private String sord;
    private List<T> list;
    private Integer totalPages;
    private Integer totalCount;

    public PageInfo(List<T> list, Integer pageNum, Integer pageSize, Integer totalPages, Integer totalCount) {
        this.list = list;
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.totalPages = totalPages;
        this.totalCount = totalCount;
    }

    public static <T> PageInfo<T> of(IPage page, Class<T> entityVoClass) {
        int pageSize;
        int total = (int)page.getTotal();
        int records = total % (pageSize = (int)page.getSize()) == 0 ? total / pageSize : total / pageSize + 1;
        PageInfo<T> pageInfo = new PageInfo<T>();
        pageInfo.setPageNum((int)page.getCurrent());
        pageInfo.setPageSize(pageSize);
        pageInfo.setList(BeanConvertUtil.copyList(page.getRecords(), entityVoClass));
        pageInfo.setTotalPages(records);
        pageInfo.setTotalCount(total);
        return pageInfo;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSidx() {
        return this.sidx;
    }

    public String getSord() {
        return this.sord;
    }

    public List<T> getList() {
        return this.list;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public PageInfo(Integer pageNum, Integer pageSize, String sidx, String sord, List<T> list, Integer totalPages, Integer totalCount) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.sidx = sidx;
        this.sord = sord;
        this.list = list;
        this.totalPages = totalPages;
        this.totalCount = totalCount;
    }

    public PageInfo() {
    }
}

