/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.aop;

import cn.gtmap.ai.core.base.RequestEntity;
import cn.gtmap.ai.core.base.RestReturnResultDto;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuthAop {
    private static final Logger log = LoggerFactory.getLogger(AuthAop.class);
    @Autowired
    ServiceFactory serviceFactory;

    @Pointcut(value="@annotation(cn.gtmap.ai.core.annotation.auth.AuthCheck)")
    public void authCheck() {
    }

    @Pointcut(value="@annotation(cn.gtmap.ai.core.annotation.auth.RestAuthCheck)")
    public void restAuthCheck() {
    }

    @Around(value="authCheck()")
    public Object checkAccessToken(ProceedingJoinPoint point) throws Throwable {
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            return ReturnResult.error(ErrorEnum.UN_AUTHORIZED);
        }
        return point.proceed();
    }

    @Around(value="restAuthCheck()")
    public Object restAuthCheck(ProceedingJoinPoint point) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (!Objects.isNull(request)) {
            Object[] args = point.getArgs();
            String token = request.getHeader("token");
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getParameter("token");
            }
            if (StringUtils.isNotBlank((CharSequence)token)) {
                token = token.replace(" ", "+");
            }
            if (!Objects.isNull(args)) {
                for (Object arg : args) {
                    Map head;
                    RequestEntity requestEntity;
                    if (!(arg instanceof RequestEntity) || Objects.isNull((requestEntity = (RequestEntity)arg).getHead()) || !(requestEntity.getHead() instanceof Map) || !StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)(head = (Map)requestEntity.getHead()), (Object)"access_token"))) continue;
                    token = MapUtils.getString((Map)head, (Object)"access_token");
                    break;
                }
            }
            request.setAttribute("token", (Object)token);
            AuthService authService = this.serviceFactory.getAuthService();
            IError iError = authService.checkToken(token);
            UserInfoDto userInfoDto = null;
            if (iError.isSuccesss()) {
                UserService userService = this.serviceFactory.getUserService();
                userInfoDto = userService.getUserByToken(token);
            }
            if (Objects.isNull(userInfoDto)) {
                MethodSignature signature = (MethodSignature)point.getSignature();
                Class<?> returnType = signature.getMethod().getReturnType();
                Object returnObj = null;
                if (Objects.isNull(returnType)) {
                    HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                    try (ServletOutputStream servletOutputStream = response.getOutputStream();){
                        servletOutputStream.write(ErrorEnum.UN_AUTHORIZED.getMsg().getBytes(StandardCharsets.UTF_8));
                    }
                } else if (returnType.getName().equals(ReturnResult.class.getName())) {
                    returnObj = ReturnResult.error(ErrorEnum.UN_AUTHORIZED);
                } else if (returnType.getName().equals(RestReturnResultDto.class.getName())) {
                    returnObj = RestReturnResultDto.error(ErrorEnum.UN_AUTHORIZED);
                }
                try {
                    return returnObj;
                }
                catch (Exception e) {
                    log.error("{} \u8bf7\u6c42\u8fd4\u56de\u503c\u5f02\u5e38", (Object)request.getRequestURL(), (Object)e);
                }
            }
        }
        return point.proceed();
    }
}

