/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.string;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";
    private static final Pattern PATTERN_BASE64 = Pattern.compile("^data.(.*?);base64,");
    private static Pattern ZW_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");

    public static synchronized String generateSlbh() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
        String nowDate = sf.format(new Date());
        Random random = new Random();
        int radInt = random.nextInt(999);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(3);
        nf.setMinimumIntegerDigits(3);
        String radStr = nf.format(radInt);
        String slbh = String.format("%s%s", nowDate, radStr);
        return slbh;
    }

    public static boolean isContainEmpty(String ... args) {
        if (args == null) {
            return false;
        }
        String[] str = args;
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            String arg = str[i];
            if (arg != null && !"".equals(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEquals(String value, String ... args) {
        if (args == null && StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if (args == null) {
                return false;
            }
            String[] str = args;
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                if (!value.equals(str[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBase64(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    public static String hex32() {
        String str = UUID.randomUUID().toString();
        return str.replace("-", "");
    }

    public static String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block8;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block8;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block8;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block8;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block8;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isChinese(String str) {
        Matcher matcher;
        boolean flg = false;
        if (StringUtils.isNotBlank((CharSequence)str) && (matcher = ZW_PATTERN.matcher(str)).find()) {
            flg = true;
        }
        return flg;
    }

    public static String toString(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static String generateVerificationCode(int length) {
        String characters = "0123456789";
        Random random = new Random();
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char randomChar = characters.charAt(random.nextInt(characters.length()));
            code.append(randomChar);
        }
        return code.toString();
    }

    public static boolean indexOfStrs(String[] a, String b) {
        boolean msg = false;
        if (a != null) {
            for (String c : a) {
                if (!StringUtils.equals((CharSequence)c, (CharSequence)b)) continue;
                msg = true;
                break;
            }
        }
        return msg;
    }

    public static String removeChineseAndBrackets(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.replaceAll("[\u4e00-\u9fa5()\uff08\uff09]", "");
        }
        return str;
    }

    public static String double6ToStr(Double d) {
        if (d == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(6);
        return nf.format(d);
    }

    public static String number2CnMontrayUnit(BigDecimal numberOfMoney) {
        StringBuilder sb = new StringBuilder();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return "\u96f6\u5143\u6574";
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, "\u8d1f");
        }
        if (scale <= 0L) {
            sb.append("\u6574");
        }
        return sb.toString();
    }

    public static double convertWanToYuan(String amountInWanStr) {
        double amountInWan = Double.parseDouble(amountInWanStr);
        return amountInWan * 10000.0;
    }

    public static Double convertWanToYuan(Double amountInWanStr) {
        if (amountInWanStr != null) {
            return amountInWanStr * 10000.0;
        }
        return null;
    }

    public static String convertWanToYuanStr(String amountInWanStr) {
        if (StringUtils.isNotBlank((CharSequence)amountInWanStr)) {
            double amountInWan = Double.parseDouble(amountInWanStr);
            return String.valueOf(amountInWan * 10000.0);
        }
        return "";
    }

    public static Double convertYuanToWan(Double amountInYuan) {
        if (amountInYuan == null) {
            return amountInYuan;
        }
        return amountInYuan / 10000.0;
    }

    public static String trimJsonKey(JSONObject json) {
        Iterator iterator = json.keySet().iterator();
        JSONObject jsonObject = new JSONObject();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = json.get((Object)key);
            if (key.contains(" ")) {
                key = key.replace(" ", "");
            }
            jsonObject.put(key, value);
            if (json.get((Object)key) instanceof JSONObject) {
                String s = StringUtil.trimJsonKey((JSONObject)((JSONObject)json.get((Object)key)));
                jsonObject.put(key, (Object)JSONObject.parseObject((String)s));
                continue;
            }
            if (!(json.get((Object)key) instanceof JSONArray)) continue;
            JSONArray array = (JSONArray)json.get((Object)key);
            JSONArray jsonArray = new JSONArray();
            for (Object item : array) {
                if (!(item instanceof JSONObject)) continue;
                String s = StringUtil.trimJsonKey((JSONObject)((JSONObject)item));
                jsonArray.add((Object)JSONObject.parseObject((String)s));
            }
            jsonObject.put(key, (Object)jsonArray);
        }
        return jsonObject.toJSONString();
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static String removeBase64Pre(String base64Str) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)base64Str) && (matcher = PATTERN_BASE64.matcher(base64Str)).find()) {
            return base64Str.replace(matcher.group(), "");
        }
        return base64Str;
    }

    public static String crossCombine(String str1, String str2) {
        if (str1.length() < str2.length()) {
            String temp = str1;
            str1 = str2;
            str2 = temp;
        }
        int repeatTimes = str1.length() / str2.length();
        String repeatedStr2 = StringUtil.repeatString((String)str2, (int)repeatTimes);
        StringBuilder combined = new StringBuilder();
        int j = 0;
        for (int i = 0; i < str1.length(); ++i) {
            combined.append(str1.charAt(i));
            if (j >= repeatedStr2.length()) continue;
            combined.append(repeatedStr2.charAt(j));
            ++j;
        }
        return combined.toString();
    }

    private static String repeatString(String str, int times) {
        StringBuilder repeated = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            repeated.append(str);
        }
        return repeated.substring(0, str.length());
    }

    public static String getFileType(String fileName) {
        String fileType = "";
        if (fileName.contains(".")) {
            fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return fileType;
    }
}

