/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.string;

import com.gtis.config.AppConfig;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathUtil {
    private static String FILEPATH_ADD_DATE = "filePath.add.date";
    private static final Logger log = LoggerFactory.getLogger(FilePathUtil.class);

    public static String addDateDirectoriesToFilePath(String filePath, String folderName) {
        String finalPath = filePath;
        if (AppConfig.getBooleanProperty((String)FILEPATH_ADD_DATE) && StringUtils.indexOf((CharSequence)filePath, (CharSequence)folderName) > -1) {
            try {
                String formattedDate = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd").format(new Date());
                String[] pathSegments = filePath.split(Matcher.quoteReplacement(File.separator));
                StringBuilder sb = new StringBuilder();
                if (pathSegments.length == 1) {
                    sb.append(pathSegments[0]).append(File.separator).append(formattedDate);
                } else {
                    for (int i = 0; i < pathSegments.length; ++i) {
                        if (i == 0) {
                            sb.append(pathSegments[i]);
                            continue;
                        }
                        if (pathSegments[i - 1].equals(folderName)) {
                            sb.append(File.separator).append(formattedDate);
                        }
                        sb.append(File.separator).append(pathSegments[i]);
                    }
                }
                finalPath = sb.toString();
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u8def\u5f84:" + filePath + ",\u8ffd\u52a0\u65e5\u671f\u76ee\u5f55\u540d:" + folderName + ",\u8ffd\u52a0\u5931\u8d25,\u8fd4\u56de\u539f\u8def\u5f84", (Throwable)e);
            }
        }
        return finalPath;
    }

    public static String getPropFolderPath() {
        String path = System.getProperty("catalina.home");
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = FilePathUtil.class.getResource("/").getPath();
            path = new File(path).getParent() + File.separator;
        } else {
            path = path + File.separator;
        }
        return path;
    }
}

