/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.http;

import com.gtis.config.AppConfig;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HttpsClientFactoryBean
implements FactoryBean<HttpClient>,
InitializingBean {
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 200;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 10;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 30000;
    private static final int DEFAULT_TIME_TO_LIVE_MILLISECONDS = 30000;
    private int maxTotalConnections = 200;
    private int maxConnectionsPerRoute = 10;
    private int soTimeout = 30000;
    private int connectionTimeout = 30000;
    private int connectionRequestTimeout = 30000;
    private int timeToLive = 30000;
    private HttpClient httpClient;

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeout(int timeout) {
        this.setSoTimeout(timeout);
        this.setConnectionTimeout(timeout);
    }

    public HttpClient getObject() throws Exception {
        return this.httpClient;
    }

    public Class<?> getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */);
        TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry, null, null, null, (long)this.timeToLive, TimeUnit.MILLISECONDS);
        if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"httpClient.maxTotalConnections"))) {
            this.maxTotalConnections = Integer.parseInt(AppConfig.getProperty((String)"httpClient.maxTotalConnections"));
        }
        if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"httpClient.maxConnectionsPerRoute"))) {
            this.maxConnectionsPerRoute = Integer.parseInt(AppConfig.getProperty((String)"httpClient.maxConnectionsPerRoute"));
        }
        connectionManager.setMaxTotal(this.maxTotalConnections);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(this.soTimeout).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build();
        this.httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config).build();
    }
}

