/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.desensitization;

import cn.gtmap.ai.core.annotation.desensitization.FieldDesensitize;
import cn.gtmap.ai.core.annotation.desensitization.TableDesensitize;
import cn.gtmap.ai.core.enums.SensitiveTypeEnum;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DesensitizedUtil {
    private static Logger logger = LoggerFactory.getLogger(DesensitizedUtil.class);
    private static final String JAVAX = "javax.";
    private static final String JAVA = "java.";
    public static final String DATATM = "dataTm";
    public static final String ITSELF = "itself";

    public static String stringDesensitize(String str, SensitiveTypeEnum annotationType) {
        String desensitizedStr = str;
        switch (1.$SwitchMap$cn$gtmap$ai$core$enums$SensitiveTypeEnum[annotationType.ordinal()]) {
            case 1: {
                desensitizedStr = DesensitizedUtil.chineseName((String)str);
                break;
            }
            case 2: {
                desensitizedStr = DesensitizedUtil.idCardNum((String)str);
                break;
            }
            case 3: {
                desensitizedStr = DesensitizedUtil.fixedPhone((String)str);
                break;
            }
            case 4: {
                desensitizedStr = DesensitizedUtil.mobilePhone((String)str);
                break;
            }
            case 5: {
                desensitizedStr = DesensitizedUtil.address((String)str);
                break;
            }
            case 6: {
                desensitizedStr = DesensitizedUtil.email((String)str);
                break;
            }
            case 7: {
                desensitizedStr = DesensitizedUtil.bankCard((String)str);
                break;
            }
            case 8: {
                desensitizedStr = DesensitizedUtil.companyBankCard((String)str);
                break;
            }
        }
        return desensitizedStr;
    }

    public static String listStringDesensitize(String strings, String separator, SensitiveTypeEnum annotationType) {
        String[] strList = strings.split(separator);
        ArrayList<String> list1 = new ArrayList<String>();
        switch (1.$SwitchMap$cn$gtmap$ai$core$enums$SensitiveTypeEnum[annotationType.ordinal()]) {
            case 1: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.chineseName((String)str));
                }
                break;
            }
            case 2: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.idCardNum((String)str));
                }
                break;
            }
            case 3: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.fixedPhone((String)str));
                }
                break;
            }
            case 4: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.mobilePhone((String)str));
                }
                break;
            }
            case 5: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.address((String)str));
                }
                break;
            }
            case 6: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.email((String)str));
                }
                break;
            }
            case 7: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.bankCard((String)str));
                }
                break;
            }
            case 8: {
                for (String str : strList) {
                    list1.add(DesensitizedUtil.companyBankCard((String)str));
                }
                break;
            }
        }
        return Joiner.on((String)separator).join(list1);
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.right((String)fullName, (int)1);
        return StringUtils.leftPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String idCardNum(String id) {
        if (StringUtils.isBlank((CharSequence)(id = StringUtils.trim((String)id)))) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)StringUtils.length((CharSequence)id), (String)"*");
    }

    public static String idCardNumByBirthday(String id) {
        if (StringUtils.isBlank((CharSequence)(id = StringUtils.trim((String)id)))) {
            return "";
        }
        return StringUtils.left((String)id, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)id, (int)4), (int)(StringUtils.length((CharSequence)id) - 9), (String)"*"), (String)"*"));
    }

    public static String fixedPhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String mobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)(num = StringUtils.trim((String)num)))) {
            return "";
        }
        if (11 != num.trim().length()) {
            return num;
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)(StringUtils.length((CharSequence)num) - 2), (String)"*"), (String)"*"));
    }

    public static String address(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.leftPad((String)StringUtils.right((String)address, (int)6), (int)length, (String)"*");
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)0), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String companyBankCard(String companyBardNum) {
        if (StringUtils.isBlank((CharSequence)companyBardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)companyBardNum);
        return StringUtils.rightPad((String)StringUtils.left((String)companyBardNum, (int)2), (int)length, (String)"*");
    }

    public static String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        String pwd = StringUtils.left((String)password, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)password), (String)"*");
    }

    public static void desensitizeObj(Object originalObj) {
        TableDesensitize tableDesensitizeAnnotation = originalObj.getClass().getAnnotation(TableDesensitize.class);
        if (Objects.isNull(tableDesensitizeAnnotation)) {
            return;
        }
        Field[] fields = originalObj.getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            FieldDesensitize fieldDesensitizeAnnotation = field.getAnnotation(FieldDesensitize.class);
            try {
                String objValue;
                field.setAccessible(true);
                if (null == fieldDesensitizeAnnotation || !StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(originalObj)))) continue;
                field.set(originalObj, DesensitizedUtil.stringDesensitize((String)objValue, (SensitiveTypeEnum)fieldDesensitizeAnnotation.type()));
            }
            catch (Exception e) {
                logger.error("desensitizeObj \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", originalObj.getClass(), (Object)field.getName());
            }
        }
    }
}

