/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.user.application.impl;

import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="olcommonUserServiceImpl")
public class OlcommonUserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(OlcommonUserServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ServiceFactory serviceFactory;

    public UserInfoDto getCurrentUser() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (!Objects.isNull(request)) {
            String key = "login:token:bysession:" + EncryptUtil.encryptStr((String)request.getSession().getId(), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
            String token = this.redisUtils.getStringValue(key);
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getHeader("token");
            }
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getParameter("token");
            }
            log.info("****getCurrentUser*****token:{} ", (Object)token);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                LoginResultDto loginResultDto;
                String userInfo = this.redisUtils.getStringValue("login:userinfo:bytoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt));
                log.info("****getCurrentUser*****userInfo:{} ", (Object)userInfo);
                if (StringUtils.isNotBlank((CharSequence)userInfo) && !Objects.isNull(loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class)) && loginResultDto.isSuccesss()) {
                    return loginResultDto.getUserInfoDto();
                }
                AuthService authService = this.serviceFactory.getAuthService();
                return authService.getUserInfoByToken(token);
            }
        }
        return null;
    }

    public UserInfoDto getUserByToken(String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            log.info("****getUserByToken*****token:{} ", (Object)token);
            String userInfo = this.redisUtils.getStringValue("login:userinfo:bytoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt));
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                log.info("****getUserByToken*****userInfo:{} ", (Object)userInfo);
                LoginResultDto loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class);
                if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
                    return loginResultDto.getUserInfoDto();
                }
            }
            AuthService authService = this.serviceFactory.getAuthService();
            return authService.getUserInfoByToken(token);
        }
        return null;
    }
}

