/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.infrastructure.convert;

import cn.gtmap.ai.core.service.dto.MultipartDto;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.GtcMultiPartConvert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GtcMultiPartConvertImpl
implements GtcMultiPartConvert {
    public MultipartDto toStorageModel(MultiPartModel multiPartModel) {
        if (multiPartModel == null) {
            return null;
        }
        MultipartDto multipartDto = new MultipartDto();
        multipartDto.setOwner(multiPartModel.getUploadUser());
        multipartDto.setClientId(multiPartModel.getAppId());
        multipartDto.setNodeId(multiPartModel.getParentFolderNodeId());
        multipartDto.setSpaceCode(multiPartModel.getStoreSpace());
        multipartDto.setOriginalFilename(multiPartModel.getOriginalFilename());
        multipartDto.setContentType(multiPartModel.getContentType());
        multipartDto.setSize(multiPartModel.getSize());
        byte[] data = multiPartModel.getData();
        if (data != null) {
            multipartDto.setData(Arrays.copyOf(data, data.length));
        }
        multipartDto.setTag(multiPartModel.getTag());
        multipartDto.setRename(multiPartModel.getRename());
        return multipartDto;
    }

    public List<MultipartDto> toStorageModelList(List<MultiPartModel> multiPartModelList) {
        if (multiPartModelList == null) {
            return null;
        }
        ArrayList<MultipartDto> list = new ArrayList<MultipartDto>(multiPartModelList.size());
        for (MultiPartModel multiPartModel : multiPartModelList) {
            list.add(this.toStorageModel(multiPartModel));
        }
        return list;
    }

    public MultiPartModel toDownModel(MultipartDto multipartDto) {
        if (multipartDto == null) {
            return null;
        }
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setParentFolderNodeId(multipartDto.getNodeId());
        multiPartModel.setStoreSpace(multipartDto.getSpaceCode());
        multiPartModel.setAppId(multipartDto.getClientId());
        multiPartModel.setUploadUser(multipartDto.getOwner());
        byte[] data = multipartDto.getData();
        if (data != null) {
            multiPartModel.setData(Arrays.copyOf(data, data.length));
        }
        multiPartModel.setOriginalFilename(multipartDto.getOriginalFilename());
        multiPartModel.setContentType(multipartDto.getContentType());
        multiPartModel.setSize(multipartDto.getSize());
        multiPartModel.setTag(multipartDto.getTag());
        multiPartModel.setRename(multipartDto.getRename());
        return multiPartModel;
    }
}

