/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.infrastructure;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.storage.domain.model.HlwFjxxModel;
import cn.gtmap.ai.core.service.storage.domain.repository.AiViewHlwFjxxRepository;
import cn.gtmap.ai.core.service.storage.dto.FjxxQuery;
import cn.gtmap.ai.core.service.storage.dto.HlwFjxxSaveDto;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.HlwFjxxModelConverter;
import cn.gtmap.ai.core.service.storage.infrastructure.mapper.AiViewHlwFjxxMapper;
import cn.gtmap.ai.core.service.storage.infrastructure.po.AiViewHlwFjxxPo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.common.util.UUIDGenerator;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AiViewHlwFjxxRepositoryImpl
extends ServiceImpl<AiViewHlwFjxxMapper, AiViewHlwFjxxPo>
implements AiViewHlwFjxxRepository,
IService<AiViewHlwFjxxPo> {
    public List<HlwFjxxModel> queryFjxx(FjxxQuery fjxxQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)fjxxQuery.getXmid())) {
            queryWrapper.eq((Object)"xmid", (Object)fjxxQuery.getXmid());
        }
        if (StringUtils.isNotBlank((CharSequence)fjxxQuery.getFjid())) {
            queryWrapper.eq((Object)"fjid", (Object)fjxxQuery.getFjid());
        }
        if (StringUtils.isNotBlank((CharSequence)fjxxQuery.getFjmc())) {
            queryWrapper.eq((Object)"fjmc", (Object)fjxxQuery.getFjmc());
        }
        return HlwFjxxModelConverter.INSTANCE.poToModelList(((AiViewHlwFjxxMapper)this.baseMapper).selectList((Wrapper)queryWrapper));
    }

    public HlwFjxxModel insertFjxx(HlwFjxxSaveDto hlwFjxxSaveDto) {
        String fjxxid = UUIDGenerator.generate18();
        AiViewHlwFjxxPo aiViewHlwFjxxPo = HlwFjxxModelConverter.INSTANCE.dtoToPo(hlwFjxxSaveDto);
        if (StringUtils.isBlank((CharSequence)aiViewHlwFjxxPo.getFjid())) {
            aiViewHlwFjxxPo.setFjid(fjxxid);
        } else {
            fjxxid = aiViewHlwFjxxPo.getFjid();
        }
        int i = ((AiViewHlwFjxxMapper)this.baseMapper).insert((Object)aiViewHlwFjxxPo);
        return i > 0 ? HlwFjxxModelConverter.INSTANCE.poToModel((AiViewHlwFjxxPo)((AiViewHlwFjxxMapper)this.baseMapper).selectById((Serializable)((Object)fjxxid))) : null;
    }

    public boolean deleteFjxxByFjid(String fjid) {
        if (StringUtils.isBlank((CharSequence)fjid)) {
            return false;
        }
        return ((AiViewHlwFjxxMapper)this.baseMapper).deleteById((Serializable)((Object)fjid)) > 0;
    }

    public HlwFjxxModel getFjxxByFjid(String fjid) {
        if (StringUtils.isBlank((CharSequence)fjid)) {
            throw new BizException((IError)ErrorEnum.PARAM_NULL);
        }
        return HlwFjxxModelConverter.INSTANCE.poToModel((AiViewHlwFjxxPo)((AiViewHlwFjxxMapper)this.baseMapper).selectById((Serializable)((Object)fjid)));
    }
}

