/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.UploadOverWriteTypeEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.storage.application.OlcommonFjxxModelService;
import cn.gtmap.ai.core.service.storage.application.OlcommonFjxxOperateService;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.service.storage.domain.model.HlwFjxmModel;
import cn.gtmap.ai.core.service.storage.dto.HlwFjxxOperateDto;
import cn.gtmap.ai.core.service.storage.dto.HlwFjxxSaveDto;
import cn.gtmap.ai.core.utils.string.FilePathUtil;
import cn.gtmap.ai.core.utils.string.StringUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="olcommonStorageServiceImpl")
public class OlcommonStorageServiceImpl
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(OlcommonStorageServiceImpl.class);
    @Autowired
    private OlcommonFjxxModelService olcommonFjxxModelService;
    @Autowired
    private OlcommonFjxxOperateService olcommonFjxxOperateService;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Value(value="${hlw.file.path:}")
    private String hlwFilePath;

    public StorageModel uploadFile(MultiPartModel multiPartModel) {
        StorageModel storageModel = null;
        String uuid = UUIDGenerator.generate18();
        Map saveResult = this.newSaveFjxmAndFjxx(multiPartModel, uuid);
        String filePath = CommonUtil.formatEmptyValue(saveResult.get("filePath"));
        String fjid = CommonUtil.formatEmptyValue(saveResult.get("fjid"));
        String xmid = CommonUtil.formatEmptyValue(saveResult.get("xmid"));
        log.info("\u65b9\u6cd5uploadFj\u4e0a\u4f20\u9644\u4ef6\u8fd4\u56defjid:{} xmid:{}", (Object)fjid, (Object)xmid);
        IError iError = (IError)MapUtils.getObject((Map)saveResult, (Object)"iError");
        if (Objects.isNull(iError) || !iError.isSuccesss()) {
            log.info("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25 \u5220\u9664fjxx\uff0cfjxm\u548c\u6587\u4ef6");
            HlwFjxxOperateDto hlwFjxxOperateDto = new HlwFjxxOperateDto();
            hlwFjxxOperateDto.setFjid(fjid);
            hlwFjxxOperateDto.setFilepath(filePath);
            this.olcommonFjxxOperateService.deleteFjxxByFjid(hlwFjxxOperateDto);
        } else {
            log.info("\u65b9\u6cd5uploadFj\u4e0a\u4f20\u9644\u4ef6\u8fd4\u56de\u7ed3\u675ffjid==" + JSON.toJSONString((Object)fjid));
            storageModel = this.olcommonFjxxModelService.getFjxxByFjid(fjid);
        }
        return storageModel;
    }

    public Map newSaveFjxmAndFjxx(MultiPartModel multiPartModel, String uuid) {
        HashMap recall = new HashMap(16);
        String time = String.valueOf(System.currentTimeMillis());
        Callable<Map> fjxxCallable = () -> this.saveFjxmAndFjxx(multiPartModel, time, uuid);
        Future fjxxFuture = this.taskExecutor.submit(fjxxCallable);
        ErrorEnum iError = ErrorEnum.SERVICE_ERROR;
        try {
            Map fjxxResult = (Map)fjxxFuture.get();
            recall.put("filePath", fjxxResult.get("filePath"));
            recall.put("xmid", fjxxResult.get("xmid"));
            recall.put("fjid", fjxxResult.get("fjid"));
            iError = (IError)MapUtils.getObject((Map)fjxxResult, (Object)"iError");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error("newSaveFjxmAndFjxx:{}", (Throwable)e);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            log.error("newSaveFjxmAndFjxx:{}", (Throwable)e);
        }
        recall.put("iError", iError);
        return recall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map saveFjxmAndFjxx(MultiPartModel multiPartModel, String time, String uuid) {
        log.info("{}:\u5f00\u59cbsaveFjxmAndFjxx( String time:{}, String fileName:{})", new Object[]{uuid, time, multiPartModel.getOriginalFilename()});
        HashMap<String, String> recall = new HashMap<String, String>(16);
        boolean overwrite = UploadOverWriteTypeEnum.overwrite((int)multiPartModel.getRename());
        boolean notSaveWhenExits = UploadOverWriteTypeEnum.notwrite((int)multiPartModel.getRename());
        String fileName = multiPartModel.getOriginalFilename();
        String fileType = StringUtil.getFileType((String)fileName);
        log.info("fileType=" + fileType);
        StorageModel storageModel = null;
        HlwFjxmModel hlwFjxmModel = null;
        String fjid = UUIDGenerator.generate();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (StringUtils.isNotBlank((CharSequence)multiPartModel.getParentFolderNodeId())) {
                hlwFjxmModel = this.olcommonFjxxModelService.getFjxmByXmid(multiPartModel.getParentFolderNodeId());
            }
            if (Objects.isNull(hlwFjxmModel)) {
                hlwFjxmModel = this.olcommonFjxxOperateService.createFjxm(multiPartModel);
            }
        }
        if (overwrite || notSaveWhenExits) {
            MultiPartModel newMultiPartModel = new MultiPartModel();
            newMultiPartModel.setParentFolderNodeId(hlwFjxmModel.getXmid());
            newMultiPartModel.setAppId(hlwFjxmModel.getSqid());
            newMultiPartModel.setOriginalFilename(fileName);
            List fjxxList = this.olcommonFjxxModelService.queryFjxx(newMultiPartModel);
            if (CollectionUtils.isNotEmpty((Collection)fjxxList)) {
                storageModel = (StorageModel)fjxxList.get(0);
                log.info("{}: \u6267\u884c saveFjxmAndFjxx( String time:{}, String storageModel:{})", new Object[]{uuid, time, JSON.toJSONString((Object)storageModel)});
            }
        }
        String xmid = hlwFjxmModel.getXmid();
        if (Objects.isNull(storageModel)) {
            String fjlx = hlwFjxmModel.getFjlx();
            String sqid = hlwFjxmModel.getSqid();
            String filepath = "";
            filepath = FilePathUtil.addDateDirectoriesToFilePath((String)("fileCenter/" + sqid + "/" + uuid), (String)"fileCenter");
            String fjmc = fileName;
            HlwFjxxSaveDto fjxx = new HlwFjxxSaveDto();
            fjxx.setXmid(xmid);
            fjxx.setCreateDate(new Date());
            fjxx.setFjlx(fjlx);
            String createUser = multiPartModel.getUploadUser();
            fjxx.setFjmc(fjmc);
            String filemc = "";
            filemc = fjmc.lastIndexOf(46) > -1 ? fjmc.substring(0, fjmc.lastIndexOf(46)) : fjmc;
            fjxx.setFilemc(filemc);
            fjxx.setFjid(fjid);
            fjxx.setFilepath(filepath);
            this.olcommonFjxxOperateService.insertFjxx(fjxx);
        } else {
            fjid = storageModel.getId();
        }
        recall.putAll(this.saveFile(multiPartModel, time, uuid, fjid));
        recall.put("xmid", xmid);
        recall.put("fjid", fjid);
        recall.put("iError", (String)ErrorEnum.SUCCESS);
        log.info("{}:\u7ed3\u675fsaveFjxmAndFjxx( String time:{}, String fileName:{})", new Object[]{uuid, time, multiPartModel.getOriginalFilename()});
        return recall;
    }

    Map saveFile(MultiPartModel multiPartModel, String time, String uuid, String fjid) {
        boolean overwrite = UploadOverWriteTypeEnum.overwrite((int)multiPartModel.getRename());
        boolean notSaveWhenExits = UploadOverWriteTypeEnum.notwrite((int)multiPartModel.getRename());
        log.info("{}:saveFile  String time\u5f00\u59cb:{}", (Object)uuid, (Object)time);
        HashMap<String, String> recall = new HashMap<String, String>(16);
        String sqid = multiPartModel.getAppId();
        String uploadPath = this.hlwFilePath;
        String filepath = FilePathUtil.addDateDirectoriesToFilePath((String)("fileCenter/" + sqid + "/" + uuid), (String)"fileCenter");
        if (overwrite || notSaveWhenExits) {
            StorageModel storageModel = this.olcommonFjxxModelService.getFjxxByFjid(fjid);
            filepath = storageModel.getPath();
        }
        String parentPath = StringUtils.isNotBlank((CharSequence)uploadPath) ? uploadPath + "/" + filepath : System.getProperty("catalina.home") + "/egov-home/bdc/data/" + filepath;
        String name = multiPartModel.getOriginalFilename();
        File uploadFile = new File(parentPath = parentPath + File.separator + name);
        if (!uploadFile.getParentFile().exists()) {
            boolean mkdirs = uploadFile.getParentFile().mkdirs();
            log.debug("mkdirs:{}", (Object)mkdirs);
        }
        if (notSaveWhenExits && uploadFile.exists() && uploadFile.length() > 0L) {
            log.info("{} \u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u4e0a\u4f20", (Object)parentPath);
            recall.put("filePath", parentPath);
            recall.put("iError", (String)ErrorEnum.SUCCESS);
            return recall;
        }
        if (overwrite && uploadFile.exists()) {
            uploadFile.deleteOnExit();
        } else if (uploadFile.exists()) {
            parentPath.replace(name, time + "-" + name);
        }
        ErrorEnum iError = ErrorEnum.FJ_PARAM_NULL;
        if (!Objects.isNull(multiPartModel.getData())) {
            iError = this.inputStreamToFile(multiPartModel.getData(), uploadFile);
        } else if (StringUtils.isNotBlank((CharSequence)multiPartModel.getFileUrl())) {
            iError = this.inputStreamToFile(multiPartModel.getFileUrl(), uploadFile);
        }
        log.info("{}:saveFile  String time\u7ed3\u675f:{}", (Object)uuid, (Object)time);
        recall.put("filePath", parentPath);
        recall.put("iError", (String)iError);
        return recall;
    }

    public IError inputStreamToFile(byte[] data, File file) {
        ErrorEnum iError = ErrorEnum.SUCCESS;
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(data);
        }
        catch (Exception e) {
            log.error("inputStreamToFile\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            iError = ErrorEnum.SERVICE_ERROR;
        }
        return iError;
    }

    public IError inputStreamToFile(String downUrl, File file) {
        ErrorEnum iError = ErrorEnum.SUCCESS;
        try {
            URL url = new URL(downUrl);
            URLConnection con = url.openConnection();
            try (InputStream is = con.getInputStream();
                 FileOutputStream os = new FileOutputStream(file);){
                int len;
                byte[] bs = new byte[1024];
                while ((len = is.read(bs)) != -1) {
                    ((OutputStream)os).write(bs, 0, len);
                }
            }
            catch (Exception e) {
                log.error("inputStreamToFile\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
                iError = ErrorEnum.SERVICE_ERROR;
            }
        }
        catch (Exception e) {
            log.error("inputStreamToFile\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            iError = ErrorEnum.SERVICE_ERROR;
        }
        return iError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageModel createFolder(MultiPartModel multiPartModel) {
        StorageModel storageModel = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            HlwFjxmModel hlwFjxmModel = this.olcommonFjxxOperateService.createFjxm(multiPartModel);
            storageModel = new StorageModel();
            if (!Objects.isNull(hlwFjxmModel)) {
                storageModel.setId(hlwFjxmModel.getXmid());
                storageModel.setTag(hlwFjxmModel.getFjlx());
                storageModel.setName(hlwFjxmModel.getFjlxmc());
            }
        }
        return storageModel;
    }

    public MultiPartModel downLoadNode(MultiPartModel multiPartModel) {
        return null;
    }

    public List<StorageModel> queryFjxx(MultiPartModel multiPartModel) {
        return this.olcommonFjxxModelService.queryFjxm(multiPartModel);
    }

    public void showFile(MultiPartModel multiPartModel, HttpServletResponse httpServletResponse) {
        this.olcommonFjxxModelService.showFile(multiPartModel, httpServletResponse);
    }
}

