/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.sms.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.service.dto.SmsResultDto;
import cn.gtmap.ai.core.service.dto.SmsSendDto;
import cn.gtmap.ai.core.service.sms.application.SmsService;
import cn.gtmap.ai.core.service.token.application.AiXtJkglModelService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Autowired
    private AiXtJkglModelService aiXtJkglModelService;
    @Value(value="${sms.csdm:}")
    private String csdm;

    public SmsResultDto sendSms(SmsSendDto smsSendDTO) {
        if (StringUtils.isBlank((CharSequence)smsSendDTO.getCsdm()) && StringUtils.isNotBlank((CharSequence)this.csdm)) {
            smsSendDTO.setCsdm(this.csdm);
        }
        log.info("sendSms.request:{}", (Object)JSON.toJSONString((Object)smsSendDTO));
        String code = "";
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm("000000");
        jkglQuery.setJkgjz("currency.sendSms.url");
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (jkglModel != null && StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
            String result = HttpUtil.post((String)jkglModel.getJkdz(), (String)JSON.toJSONString((Object)smsSendDTO), null, null);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return (SmsResultDto)JSON.parseObject((String)result, SmsResultDto.class);
            }
            code = ErrorEnum.JKDYSB.getCode();
        } else {
            code = ErrorEnum.PZX_NOT_EXISTS.getCode();
        }
        SmsResultDto resultDto = new SmsResultDto();
        resultDto.setCode(Integer.valueOf(Integer.parseInt(code)));
        return resultDto;
    }
}

