/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.setting.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.service.setting.application.AiXtPzxService;
import cn.gtmap.ai.core.service.setting.domian.model.AiXtPzx;
import cn.gtmap.ai.core.service.setting.domian.repository.AiXtPzxRepository;
import cn.gtmap.ai.core.service.setting.query.PzxQuery;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AiXtPzxServiceImpl
implements AiXtPzxService {
    @Autowired
    private AiXtPzxRepository aiXtPzxRepository;
    @Autowired
    private RedisUtils redisUtils;
    private final String PZX_KEY = "AI_REAL_ESTATE_PZX:";

    public void resetAllPzx() {
        List aiXtPzxList = this.aiXtPzxRepository.listAiXtPzx(null);
        if (CollectionUtils.isNotEmpty((Collection)aiXtPzxList)) {
            for (AiXtPzx aiXtPzx : aiXtPzxList) {
                this.redisUtils.addStringValue("AI_REAL_ESTATE_PZX:" + aiXtPzx.getYydm() + ":" + aiXtPzx.getPzxlxdm() + ":" + aiXtPzx.getPzxdm(), JSON.toJSONString((Object)aiXtPzx));
            }
        }
    }

    public List<AiXtPzx> listPzx(PzxQuery pzxQuery) {
        List aiXtPzxList = this.aiXtPzxRepository.listAiXtPzx(pzxQuery);
        return aiXtPzxList;
    }

    public AiXtPzx getPzx(PzxQuery pzxQuery) {
        AiXtPzx aiXtPzx = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pzxQuery.getYydm(), pzxQuery.getPzxlxdm(), pzxQuery.getPzxdm()})) {
            String pzxStr = this.redisUtils.getStringValue("AI_REAL_ESTATE_PZX:" + pzxQuery.getYydm() + ":" + pzxQuery.getPzxlxdm() + ":" + pzxQuery.getPzxdm());
            aiXtPzx = StringUtils.isNotEmpty((CharSequence)pzxStr) ? (AiXtPzx)JSON.parseObject((String)pzxStr, AiXtPzx.class) : this.aiXtPzxRepository.getAiXtPzxByPzxQuery(pzxQuery);
            if (null != aiXtPzx && StringUtils.isNotEmpty((CharSequence)pzxQuery.getPzxzt()) && !StringUtils.equals((CharSequence)pzxQuery.getPzxzt(), (CharSequence)aiXtPzx.getPzxzt())) {
                aiXtPzx = null;
            }
            return aiXtPzx;
        }
        throw new ParamException((IError)ErrorEnum.PARAM_NULL);
    }
}

