/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.auth.application.impl;

import cn.gtmap.ai.core.base.AuthTokenDto;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.exception.TokenException;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.application.convert.UserInfoConverter;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoRoleDto;
import cn.gtmap.ai.core.service.token.application.impl.AiXtJkglModelServiceImpl;
import cn.gtmap.ai.core.service.token.domian.model.AiXtDsfxtjr;
import cn.gtmap.ai.core.service.token.domian.model.AiXtJkgl;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.OlcommonBaseRequestBo;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.OlcommonBaseResponseDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.encrypt.OlcommonEncryptBO;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.encrypt.OlcommonEncryptDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.login.OlcommonLoginBO;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.login.OlcommonLoginDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.logout.OlcommonLogoutBO;
import cn.gtmap.ai.core.service.token.domian.repository.AiXtDsfxtjrRepository;
import cn.gtmap.ai.core.service.token.domian.repository.AiXtJkglRepository;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.service.user.domain.model.olcommon.user.OlcommonUserInfoBO;
import cn.gtmap.ai.core.service.user.domain.model.olcommon.user.OlcommonUserInfoDto;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import cn.gtmap.ai.core.utils.string.StringUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.estateplat.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="olcommonAuthServiceImpl")
public class OlcommonAuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(OlcommonAuthServiceImpl.class);
    @Value(value="${ai.token.qydm:000000}")
    private String qydm;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AiXtJkglModelServiceImpl aiXtJkglModelService;
    @Autowired
    private AiXtJkglRepository aiXtJkglRepository;
    @Autowired
    private AiXtDsfxtjrRepository aiXtDsfxtjrRepository;
    private final String LOGIN_JKGJZ = "register.login.url";
    private final String LOGOUT_JKGJZ = "olcommon.logout.url";
    private final String ENCRYPT_JKGJZ = "olcommon.encrypt.url";
    private final String USERINFO_JKGJZ = "olcommon.userinfo.url";

    public LoginResultDto login(LoginUserBaseDto loginUserBaseDto) {
        LoginResultDto loginResultDto = new LoginResultDto();
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getLxdh(), loginUserBaseDto.getPassword()})) {
            loginResultDto.setError(ErrorEnum.PARAM_NULL);
            return loginResultDto;
        }
        JkglQuery tokenJkglQuery = new JkglQuery();
        tokenJkglQuery.setJkgjz("register.login.url");
        tokenJkglQuery.setQydm(this.qydm);
        AiXtJkgl aiXtJkglToken = this.aiXtJkglModelService.replaceJkglProperties(tokenJkglQuery);
        if (null != aiXtJkglToken) {
            tokenJkglQuery.setJkgjz(null);
            tokenJkglQuery.setYydm(aiXtJkglToken.getYydm());
            tokenJkglQuery.setQydm(aiXtJkglToken.getQydm());
            AiXtDsfxtjr aiXtDsfxtjr = this.aiXtDsfxtjrRepository.getAiXtDsfxtjrByJkglQuery(tokenJkglQuery);
            if (null != aiXtDsfxtjr && JSONValidator.from((String)aiXtDsfxtjr.getJrcs()).validate() && (loginResultDto = this.getToken(aiXtJkglToken, aiXtDsfxtjr, loginUserBaseDto)).isSuccesss() && Objects.isNull(loginResultDto.getUserInfoDto())) {
                this.getUserInfo(loginResultDto.getToken(), loginResultDto);
            }
        }
        return loginResultDto;
    }

    public IError logout() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SUCCESS;
        }
        String token = request.getParameter("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.redisUtils.getStringValue("login:token:bysession:" + EncryptUtil.encryptStr((String)request.getSession().getId(), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt));
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Object userInfoDto = null;
            JkglQuery jkglQuery = new JkglQuery();
            jkglQuery.setJkgjz("olcommon.logout.url");
            jkglQuery.setQydm(this.qydm);
            JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
            if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
                String userInfo;
                OlcommonBaseResponseDto olcommonBaseEncryptDto;
                OlcommonBaseRequestBo olcommonBaseUserInfoRequestBo = new OlcommonBaseRequestBo(OlcommonLogoutBO.class);
                olcommonBaseUserInfoRequestBo.getHead().setAccessToken(token);
                String result = HttpUtil.post((String)jkglModel.getJkdz(), (String)JSON.toJSONString((Object)olcommonBaseUserInfoRequestBo), null, null);
                log.info("olcommon.encrypt.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), jkglModel.getJkdz(), result});
                if (JSONValidator.from((String)result).validate() && !Objects.isNull(olcommonBaseEncryptDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])) && olcommonBaseEncryptDto.isSuccess() && StringUtils.isNotBlank((CharSequence)(userInfo = this.redisUtils.getStringValue("login:userinfo:bytoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt))))) {
                    LoginResultDto loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class);
                    if (!Objects.isNull(loginResultDto) && !Objects.isNull(loginResultDto.getUserInfoDto()) && StringUtils.isNotBlank((CharSequence)loginResultDto.getUserInfoDto().getLxdh())) {
                        this.redisUtils.deleteKey("login:token:byloginname:" + EncryptUtil.encryptStr((String)(loginResultDto.getUserInfoDto().getLxdh() + "000000"), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt));
                    }
                    return ErrorEnum.SUCCESS;
                }
                return ErrorEnum.UN_AUTHORIZED;
            }
            return ErrorEnum.PZX_NOT_EXISTS;
        }
        return ErrorEnum.UN_AUTHORIZED;
    }

    public LoginResultDto getToken(AiXtJkgl aiXtJkglToken, AiXtDsfxtjr aiXtDsfxtjr, LoginUserBaseDto loginUserBaseDto) {
        String token;
        LoginResultDto loginResultDto = new LoginResultDto();
        if (Objects.isNull(aiXtJkglToken) || StringUtils.isBlank((CharSequence)aiXtJkglToken.getJkdz())) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u63a5\u53e3\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String accessToken = "";
        String lxdh = null;
        String password = null;
        String encodeValue = null;
        if (!Objects.isNull(loginUserBaseDto) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getLxdh(), loginUserBaseDto.getPassword()})) {
            lxdh = loginUserBaseDto.getLxdh();
            password = loginUserBaseDto.getPassword();
        } else if (!Objects.isNull(aiXtDsfxtjr) && StringUtils.isNotBlank((CharSequence)aiXtDsfxtjr.getJrcs())) {
            JSONObject jrqtcs = JSONObject.parseObject((String)aiXtDsfxtjr.getJrcs());
            lxdh = CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"lxdh"));
            encodeValue = password = Sm2lib.decode((String)CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"password")));
        }
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lxdh, password})) {
            loginResultDto.setError(ErrorEnum.PARAM_NULL);
            return loginResultDto;
        }
        String redisKey = "login:token:byloginname:" + EncryptUtil.encryptStr((String)lxdh, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
        String qydm = aiXtJkglToken.getQydm();
        if (StringUtils.isNotBlank((CharSequence)qydm)) {
            redisKey = redisKey + "_" + qydm;
        }
        if (StringUtils.isNotBlank((CharSequence)(token = this.redisUtils.getStringValue(redisKey)))) {
            log.info("{},\u83b7\u53d6\u65f6\u95f4:{},\u672a\u8fc7\u671f", (Object)redisKey, (Object)DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT));
            this.getUserInfo(token, loginResultDto);
            if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
                accessToken = token;
            }
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            if (StringUtils.isBlank((CharSequence)encodeValue)) {
                JkglQuery jkglQuery = new JkglQuery();
                jkglQuery.setJkgjz("olcommon.encrypt.url");
                jkglQuery.setQydm(qydm);
                JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                String queryUrl = "";
                if (jkglModel != null && StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
                    OlcommonBaseResponseDto olcommonBaseEncryptDto;
                    queryUrl = jkglModel.getJkdz();
                    OlcommonBaseRequestBo olcommonBaseEncryptRequestBo = new OlcommonBaseRequestBo(OlcommonEncryptBO.class);
                    OlcommonEncryptBO olcommonEncryptBO = (OlcommonEncryptBO)olcommonBaseEncryptRequestBo.getData();
                    olcommonEncryptBO.setEncodeKey(password);
                    String result = HttpUtil.post((String)jkglModel.getJkdz(), (String)JSON.toJSONString((Object)olcommonBaseEncryptRequestBo), null, null);
                    log.info("olcommon.encrypt.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, result});
                    if (JSONValidator.from((String)result).validate() && !Objects.isNull(olcommonBaseEncryptDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])) && olcommonBaseEncryptDto.isSuccess()) {
                        String string = encodeValue = Objects.isNull(olcommonBaseEncryptDto.getData()) ? null : ((OlcommonEncryptDto)olcommonBaseEncryptDto.getData()).getEncodeValue();
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)encodeValue)) {
                OlcommonBaseResponseDto olcommonBaseLoginDto;
                String olcommonyhqxTokenKeyUrl = aiXtJkglToken.getJkdz();
                OlcommonBaseRequestBo olcommonBaseLoginRequestBo = new OlcommonBaseRequestBo(OlcommonLoginBO.class);
                OlcommonLoginBO olcommonLoginBO = (OlcommonLoginBO)olcommonBaseLoginRequestBo.getData();
                olcommonLoginBO.setLxDh(lxdh);
                olcommonLoginBO.setUserPwd(encodeValue);
                String result = HttpUtil.post((String)olcommonyhqxTokenKeyUrl, (String)JSON.toJSONString((Object)olcommonBaseLoginRequestBo), null, null);
                log.info("olcommon.token.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), olcommonyhqxTokenKeyUrl, result});
                if (JSONValidator.from((String)result).validate() && !Objects.isNull(olcommonBaseLoginDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])) && olcommonBaseLoginDto.isSuccess()) {
                    String string = accessToken = Objects.isNull(olcommonBaseLoginDto.getData()) ? null : ((OlcommonLoginDto)olcommonBaseLoginDto.getData()).getAccessToken();
                    if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                        loginResultDto.setExpiresIn(5400L);
                        loginResultDto.setToken(accessToken);
                        loginResultDto.setError(ErrorEnum.SUCCESS);
                        this.redisUtils.addStringValue(redisKey, accessToken, loginResultDto.getExpiresIn());
                    }
                }
            }
        }
        return loginResultDto;
    }

    public void getUserInfo(String token, LoginResultDto loginResultDto) {
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setJkgjz("olcommon.userinfo.url");
        jkglQuery.setQydm(this.qydm);
        AiXtJkgl aiXtJkglUser = this.aiXtJkglModelService.replaceJkglProperties(jkglQuery);
        if (!Objects.isNull(aiXtJkglUser) && StringUtils.isNotBlank((CharSequence)aiXtJkglUser.getJkdz())) {
            OlcommonBaseRequestBo olcommonBaseUserInfoRequestBo = new OlcommonBaseRequestBo(OlcommonUserInfoBO.class);
            OlcommonUserInfoBO olcommonUserInfoBO = (OlcommonUserInfoBO)olcommonBaseUserInfoRequestBo.getData();
            olcommonUserInfoBO.setAccessToken(token);
            String queryUrl = aiXtJkglUser.getJkdz();
            String result = HttpUtil.post((String)queryUrl, (String)JSON.toJSONString((Object)olcommonBaseUserInfoRequestBo), null, null);
            log.info("olcommon.userinfo.key {} httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, result});
            if (JSONValidator.from((String)result).validate()) {
                OlcommonBaseResponseDto olcommonBaseUserInfoDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                if (!olcommonBaseUserInfoDto.isSuccess()) {
                    if (!Objects.isNull(olcommonBaseUserInfoDto.getHead())) {
                        throw new TokenException(olcommonBaseUserInfoDto.getHead().getCode(), olcommonBaseUserInfoDto.getHead().getMsg());
                    }
                    throw new BizException((IError)ErrorEnum.SERVICE_ERROR);
                }
                OlcommonUserInfoDto olcommonUserInfoDto = (OlcommonUserInfoDto)olcommonBaseUserInfoDto.getData();
                if (Objects.isNull(olcommonUserInfoDto)) {
                    log.info("getUserInfo() - olcommonUserInfoDto \u503c\u4e3a\u7a7a");
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                    token = StringUtil.crossCombine((String)token, (String)loginResultDto.getClientId());
                }
                UserInfoDto userInfoDto = UserInfoConverter.INSTANCE.olcommonUserToUserInfoDto(olcommonUserInfoDto);
                userInfoDto.setDxfyhInfo(JSON.toJSONString((Object)olcommonUserInfoDto));
                DesensitizedUtil.desensitizeObj((Object)userInfoDto);
                ArrayList roleDtoList = Lists.newArrayList();
                userInfoDto.setRoleList((List)roleDtoList);
                UserInfoRoleDto userInfoRoleDto = new UserInfoRoleDto();
                userInfoRoleDto.setRoleId(String.valueOf(olcommonUserInfoDto.getRole()));
                userInfoRoleDto.setRoleName(olcommonUserInfoDto.getRoleName());
                loginResultDto.setUserInfoDto(userInfoDto);
                loginResultDto.setToken(token);
                loginResultDto.setError(ErrorEnum.SUCCESS);
                loginResultDto.setExpiresIn(5400L);
                String redisKey = "login:userinfo:bytoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
                this.redisUtils.addStringValue(redisKey, JSON.toJSONString((Object)loginResultDto), loginResultDto.getExpiresIn());
            } else {
                loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
        }
    }

    public UserInfoDto getUserInfoByToken(String token) {
        LoginResultDto loginResultDto = new LoginResultDto();
        this.getUserInfo(token, loginResultDto);
        if (loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        String orinalToken = this.redisUtils.getStringValue("login:orginaltoken:byclienttoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt));
        this.getUserInfo(orinalToken, loginResultDto);
        if (loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        return null;
    }

    public IError checkLogin(LoginUserBaseDto loginUserBaseDto) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SERVICE_ERROR;
        }
        String redisKey = "login:token:bysession:" + EncryptUtil.encryptStr((String)request.getSession().getId(), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
        String token = this.redisUtils.getStringValue(redisKey);
        return StringUtils.isNotBlank((CharSequence)token) ? ErrorEnum.SUCCESS : ErrorEnum.SERVICE_ERROR;
    }

    public AuthTokenDto generateToken(LoginUserBaseDto loginUserBaseDto) {
        log.info("**********LoginUserBaseDto:{}***********", (Object)JSON.toJSONString((Object)loginUserBaseDto));
        AuthTokenDto authTokenDto = new AuthTokenDto();
        LoginResultDto loginResultDto = new LoginResultDto();
        JkglQuery tokenJkglQuery = new JkglQuery();
        tokenJkglQuery.setJkgjz("register.login.url");
        tokenJkglQuery.setQydm(this.qydm);
        AiXtJkgl aiXtJkglToken = this.aiXtJkglModelService.replaceJkglProperties(tokenJkglQuery);
        if (Objects.isNull(aiXtJkglToken)) {
            return authTokenDto;
        }
        String accessToken = "";
        if (StringUtils.isNotBlank((CharSequence)aiXtJkglToken.getJkdz())) {
            String lxdh = null;
            String password = null;
            String encodeValue = null;
            if (!Objects.isNull(loginUserBaseDto) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getYhm(), loginUserBaseDto.getMm()})) {
                lxdh = loginUserBaseDto.getYhm();
                password = loginUserBaseDto.getMm();
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lxdh, password})) {
                throw new TokenException((IError)ErrorEnum.PARAM_NULL);
            }
            boolean differentClient = StringUtils.isNotBlank((CharSequence)loginUserBaseDto.getClientId());
            loginResultDto.setClientId(loginUserBaseDto.getClientId());
            String redisKey = differentClient ? "login:resttoken:byloginname:" + EncryptUtil.encryptStr((String)StringUtil.crossCombine((String)lxdh, (String)loginUserBaseDto.getClientId()), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt) : "login:resttoken:byloginname:" + EncryptUtil.encryptStr((String)lxdh, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
            String qydm = aiXtJkglToken.getQydm();
            if (StringUtils.isNotBlank((CharSequence)qydm)) {
                redisKey = redisKey + "_" + qydm;
            }
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                if (StringUtils.isBlank(encodeValue)) {
                    JkglQuery jkglQuery = new JkglQuery();
                    jkglQuery.setJkgjz("olcommon.encrypt.url");
                    jkglQuery.setQydm(qydm);
                    JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                    String queryUrl = "";
                    if (jkglModel != null && StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
                        OlcommonBaseResponseDto olcommonBaseEncryptDto;
                        queryUrl = jkglModel.getJkdz();
                        OlcommonBaseRequestBo olcommonBaseEncryptRequestBo = new OlcommonBaseRequestBo(OlcommonEncryptBO.class);
                        OlcommonEncryptBO olcommonEncryptBO = (OlcommonEncryptBO)olcommonBaseEncryptRequestBo.getData();
                        olcommonEncryptBO.setEncodeKey(password);
                        String result = HttpUtil.post((String)jkglModel.getJkdz(), (String)JSON.toJSONString((Object)olcommonBaseEncryptRequestBo), null, null);
                        log.info("olcommon.encrypt.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, result});
                        if (JSONValidator.from((String)result).validate() && !Objects.isNull(olcommonBaseEncryptDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])) && olcommonBaseEncryptDto.isSuccess()) {
                            String string = encodeValue = Objects.isNull(olcommonBaseEncryptDto.getData()) ? null : ((OlcommonEncryptDto)olcommonBaseEncryptDto.getData()).getEncodeValue();
                        }
                    }
                }
                if (StringUtils.isNotBlank(encodeValue)) {
                    OlcommonBaseResponseDto olcommonBaseLoginDto;
                    String olcommonyhqxTokenKeyUrl = aiXtJkglToken.getJkdz();
                    OlcommonBaseRequestBo olcommonBaseLoginRequestBo = new OlcommonBaseRequestBo(OlcommonLoginBO.class);
                    OlcommonLoginBO olcommonLoginBO = (OlcommonLoginBO)olcommonBaseLoginRequestBo.getData();
                    olcommonLoginBO.setLxDh(lxdh);
                    olcommonLoginBO.setUserPwd(encodeValue);
                    String result = HttpUtil.post((String)olcommonyhqxTokenKeyUrl, (String)JSON.toJSONString((Object)olcommonBaseLoginRequestBo), null, null);
                    log.info("olcommon.token.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), olcommonyhqxTokenKeyUrl, result});
                    if (JSONValidator.from((String)result).validate() && !Objects.isNull(olcommonBaseLoginDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0])) && olcommonBaseLoginDto.isSuccess()) {
                        String orginaltoken = accessToken = Objects.isNull(olcommonBaseLoginDto.getData()) ? null : ((OlcommonLoginDto)olcommonBaseLoginDto.getData()).getAccessToken();
                        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                            loginResultDto.setExpiresIn(5400L);
                            loginResultDto.setToken(accessToken);
                            loginResultDto.setError(ErrorEnum.SUCCESS);
                            this.getUserInfo(accessToken, loginResultDto);
                            if (differentClient) {
                                accessToken = StringUtil.crossCombine((String)accessToken, (String)loginUserBaseDto.getClientId());
                            }
                            authTokenDto.setToken(accessToken);
                            authTokenDto.setExpireIn(((OlcommonLoginDto)olcommonBaseLoginDto.getData()).getExpiresIn());
                            this.redisUtils.addStringValue(redisKey, accessToken, loginResultDto.getExpiresIn());
                            this.redisUtils.addStringValue("login:loginname:bytoken:" + EncryptUtil.encryptStr((String)accessToken, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt), lxdh, loginResultDto.getExpiresIn());
                            if (differentClient) {
                                this.redisUtils.addStringValue("login:orginaltoken:byclienttoken:" + EncryptUtil.encryptStr((String)accessToken, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt), orginaltoken, loginResultDto.getExpiresIn());
                                this.redisUtils.addStringValue("login:restclientid:bytoken:" + EncryptUtil.encryptStr((String)accessToken, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt), loginUserBaseDto.getClientId(), loginResultDto.getExpiresIn());
                            }
                        }
                    }
                }
            }
        }
        return authTokenDto;
    }

    public IError checkToken(String token) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SERVICE_ERROR;
        }
        String redisKey = "login:loginname:bytoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
        return StringUtils.isNotBlank((CharSequence)this.redisUtils.getStringValue(redisKey)) ? ErrorEnum.SUCCESS : ErrorEnum.SERVICE_ERROR;
    }
}

