/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.auth.application.impl;

import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AppAuthService;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.application.convert.UserInfoConverter;
import cn.gtmap.ai.core.service.auth.domain.model.login.AppLoginBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.gtis.common.util.TokenUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="myycAppAuthServiceImpl")
public class MyycAppAuthServiceImpl
implements AppAuthService {
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;

    public LoginResultDto appLogin(AppLoginBaseDto appLoginBaseDto) {
        AuthService authService = this.serviceFactory.getAuthService();
        LoginUserBaseDto loginUserBaseDto = UserInfoConverter.INSTANCE.appLoginBaseDtoToLoginUserBaseDto(appLoginBaseDto);
        String token = TokenUtils.BuildToken();
        LoginResultDto loginResultDto = new LoginResultDto();
        UserInfoDto userInfoDto = new UserInfoDto();
        loginResultDto.setUserInfoDto(userInfoDto);
        userInfoDto.setLxdh(appLoginBaseDto.getLxdh());
        userInfoDto.setLxdhTm(appLoginBaseDto.getLxdh());
        userInfoDto.setUserId(appLoginBaseDto.getUserId());
        userInfoDto.setLoginName(appLoginBaseDto.getUserName());
        userInfoDto.setLoginNameTm(appLoginBaseDto.getUserName());
        userInfoDto.setUserName(appLoginBaseDto.getRealName());
        userInfoDto.setUserNameTm(appLoginBaseDto.getRealName());
        userInfoDto.setUserZjh(appLoginBaseDto.getUserZjh());
        userInfoDto.setUserZjhTm(appLoginBaseDto.getUserZjh());
        DesensitizedUtil.desensitizeObj((Object)userInfoDto);
        loginResultDto.setError(ErrorEnum.SUCCESS);
        loginResultDto.setToken(token);
        loginResultDto.setExpiresIn(5400L);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (!Objects.isNull(request)) {
            String userRedisKey = "login:userinfo:bytoken:" + EncryptUtil.encryptStr((String)token, (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
            this.redisUtils.addStringValue(userRedisKey, JSON.toJSONString((Object)loginResultDto), loginResultDto.getExpiresIn());
        }
        return loginResultDto;
    }
}

