/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service;

import cn.gtmap.ai.core.enums.LoginAppEnum;
import cn.gtmap.ai.core.service.auth.application.AppAuthService;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.user.application.UserService;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ServiceFactory {
    @Value(value="${plat.key:gtc}")
    private String serviceKey;
    @Value(value="${authplat.key:olcommon}")
    private String authServiceKey;
    @Autowired
    private Map<String, StorageService> storageServiceMap;
    @Autowired
    private Map<String, AuthService> authServiceMap;
    @Autowired
    private Map<String, UserService> userServiceMap;
    @Autowired
    private Map<String, AppAuthService> appAuthServiceMap;
    private static final String storageServiceSufix = "StorageServiceImpl";
    private static final String logServiceSufix = "LogServiceImpl";
    private static final String authServiceSufix = "AuthServiceImpl";
    private static final String userServiceSufix = "UserServiceImpl";
    private static final String appAuthServiceSufix = "AppAuthServiceImpl";

    public StorageService getStorageService() {
        StorageService service = (StorageService)MapUtils.getObject((Map)this.storageServiceMap, (Object)(this.serviceKey + storageServiceSufix));
        return service;
    }

    public AuthService getAuthService() {
        AuthService service = (AuthService)MapUtils.getObject((Map)this.authServiceMap, (Object)(this.authServiceKey + authServiceSufix));
        return service;
    }

    public UserService getUserService() {
        UserService service = (UserService)MapUtils.getObject((Map)this.userServiceMap, (Object)(this.authServiceKey + userServiceSufix));
        return service;
    }

    public AppAuthService getAppAuthService(LoginAppEnum loginAppEnum) {
        AppAuthService service = (AppAuthService)MapUtils.getObject((Map)this.appAuthServiceMap, (Object)(loginAppEnum.getLoginAppType() + appAuthServiceSufix));
        return service;
    }
}

