/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.token;

import cn.gtmap.ai.core.base.AuthTokenDto;
import cn.gtmap.ai.core.base.RestReturnResultDto;
import cn.gtmap.ai.core.base.ReturnHead;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.base.ThirdRequestEncryptUserDto;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.TokenErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.OlcommonBaseRequestDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rest/v1/wwsq"})
public class RestWwsqTokenController {
    private static final Logger log = LoggerFactory.getLogger(RestWwsqTokenController.class);
    @Autowired
    private ThirdRequestEncryptUserDto thirdRequestEncryptUserDto;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ServiceFactory serviceFactory;

    @PostMapping(value={"/getToken"})
    @ResponseBody
    public RestReturnResultDto simpleLogin(@RequestBody OlcommonBaseRequestDto<LoginUserBaseDto> olcommonBaseRequestDto, HttpServletRequest request, HttpServletResponse response) {
        AuthService authService = this.serviceFactory.getAuthService();
        AuthTokenDto authTokenDto = authService.generateToken((LoginUserBaseDto)olcommonBaseRequestDto.getData());
        return Objects.isNull(authTokenDto) || StringUtils.isBlank((CharSequence)authTokenDto.getToken()) ? RestReturnResultDto.error((IError)TokenErrorEnum.GET_ACCESSTOKEN_FAILED) : RestReturnResultDto.success((Object)authTokenDto);
    }

    @PostMapping(value={"/encryptauth"})
    @ResponseBody
    public RestReturnResultDto simpleLogin(HttpServletRequest request, HttpServletResponse response) {
        ReturnResult returnResult = ReturnResult.success((Object)this.thirdRequestEncryptUserDto);
        return RestReturnResultDto.success((Object)returnResult);
    }

    @PostMapping(value={"/encrypt"})
    @ResponseBody
    public RestReturnResultDto encrypt(@RequestBody OlcommonBaseRequestDto<String> olcommonBaseRequestDto, HttpServletRequest request, HttpServletResponse response) {
        String str = (String)olcommonBaseRequestDto.getData();
        ReturnHead returnHead = null;
        String emcryptStr = null;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            emcryptStr = EncryptUtil.encryptStr((String)str, (EncryptTypeEnum)EncryptTypeEnum.SM2);
            returnHead = ReturnHead.success();
        } else {
            returnHead = ReturnHead.error((IError)ErrorEnum.PARAM_NULL);
        }
        return new RestReturnResultDto(returnHead, (Object)emcryptStr);
    }

    @RequestMapping(value={"/userbytoken"})
    @ResponseBody
    public RestReturnResultDto userbytoken() {
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            return RestReturnResultDto.error((IError)TokenErrorEnum.SIGNATURE_VERIFICATION_ERROR);
        }
        return RestReturnResultDto.success((Object)userInfoDto);
    }
}

