/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.login.apps;

import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.TokenErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.app.application.impl.MyycAppServiceImpl;
import cn.gtmap.ai.core.service.app.domain.dto.myyc.MyYcFaceDataDto;
import cn.gtmap.ai.core.service.app.domain.query.myyc.MyycFaceQuery;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/myyc/v1"})
public class MyycAppController {
    @Autowired
    MyycAppServiceImpl myYcAppService;
    @Autowired
    RedisUtils redisUtils;

    @ResponseBody
    @RequestMapping(value={"/getinitcode"})
    public ReturnResult getInitcode() {
        Map map = this.myYcAppService.getMyYcAppInitCode();
        String code = CommonUtil.formatEmptyValue(map.get("code"));
        ReturnResult returnResult = ReturnResult.error((IError)ErrorEnum.getError((String)code));
        returnResult.setData((Object)map);
        return returnResult;
    }

    @ResponseBody
    @RequestMapping(value={"/getaccesstoken"})
    public ReturnResult getAccessToken() {
        Map map = new HashMap<String, String>(16);
        String code = TokenErrorEnum.GET_ACCESSTOKEN_FAILED.getCode();
        String accessToken = CommonUtil.formatEmptyValue((Object)this.redisUtils.getStringValue("myYcAppAccessToken"));
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            map.put("accessToken", accessToken);
            code = ErrorEnum.SUCCESS.getCode();
        } else {
            map = this.myYcAppService.getMyYcAppAccessToken();
            code = CommonUtil.formatEmptyValue(map.get("code"));
        }
        ReturnResult returnResult = ReturnResult.error((IError)ErrorEnum.getError((String)code));
        returnResult.setData(map);
        return returnResult;
    }

    @ResponseBody
    @RequestMapping(value={"/getFaceBase64"})
    public ReturnResult getFaceBase64(@RequestBody MyycFaceQuery myycFaceQuery) {
        String appId = myycFaceQuery.getAppId();
        String phone = myycFaceQuery.getPhone();
        HashMap map = Maps.newHashMap();
        map.put("phone", phone);
        String code = ErrorEnum.PARAM_NULL.getCode();
        MyYcFaceDataDto result = new MyYcFaceDataDto();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId, phone})) {
            result = this.myYcAppService.getFaceBase64((Map)map);
            code = ErrorEnum.SUCCESS.getCode();
        }
        ReturnResult returnResult = ReturnResult.error((IError)ErrorEnum.getError((String)code));
        returnResult.setData((Object)map);
        return returnResult;
    }

    @ResponseBody
    @RequestMapping(value={"/getuserinfo"})
    public ReturnResult getUserInfo(@RequestBody MyycFaceQuery myycFaceQuery, HttpServletRequest request) {
        String requestCode = myycFaceQuery.getRequestCode();
        LoginResultDto loginResultDto = null;
        ErrorEnum errorEnum = ErrorEnum.PARAM_NULL;
        String redisKey = "login:token:bysession:" + EncryptUtil.encryptStr((String)request.getSession().getId(), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
        if (StringUtils.isNotBlank((CharSequence)requestCode)) {
            loginResultDto = this.myYcAppService.getMyYcAppUserInfo(requestCode);
            if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
            }
            errorEnum = loginResultDto.getError();
            loginResultDto.setError(null);
        }
        ReturnResult returnResult = ReturnResult.error((IError)errorEnum);
        returnResult.setData((Object)loginResultDto);
        return returnResult;
    }
}

