/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.login;

import cn.gtmap.ai.core.annotation.auth.AuthCheck;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.TokenErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AppAuthService;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.login.AppLoginBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.kaptcha.VerifyUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/login/v1"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Value(value="${letter.yzm.use:true}")
    private boolean letterYzmUse;
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/simpleLogin"})
    @ResponseBody
    public ReturnResult simpleLogin(@RequestBody LoginUserBaseDto loginUserBaseDto, HttpServletRequest request, HttpServletResponse response) {
        boolean yzmVerFified;
        if (StringUtils.isNotBlank((CharSequence)loginUserBaseDto.getPassword())) {
            loginUserBaseDto.setPassword(Sm2lib.pzxDecode((String)loginUserBaseDto.getPassword()));
        }
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getPassword(), loginUserBaseDto.getLxdh()})) {
            return ReturnResult.error((IError)ErrorEnum.PARAM_NULL);
        }
        boolean bl = yzmVerFified = !this.letterYzmUse;
        if (this.letterYzmUse) {
            yzmVerFified = VerifyUtil.checkVerifyCode((HttpServletRequest)request, (LoginUserBaseDto)loginUserBaseDto);
        }
        if (!yzmVerFified) {
            return ReturnResult.error((IError)TokenErrorEnum.YZM_FAILED);
        }
        String redisKey = "login:token:bysession:" + EncryptUtil.encryptStr((String)request.getSession().getId(), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
        LoginResultDto loginResultDto = null;
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            AuthService authService = this.serviceFactory.getAuthService();
            loginResultDto = authService.login(loginUserBaseDto);
            if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
            }
        } else {
            String token = this.redisUtils.getStringValue(redisKey);
            loginResultDto = new LoginResultDto();
            loginResultDto.setUserInfoDto(userInfoDto);
            loginResultDto.setError(ErrorEnum.SUCCESS);
            loginResultDto.setToken(token);
        }
        if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
            loginResultDto.setError(null);
            loginResultDto.setExpiresIn(0L);
            return ReturnResult.success((Object)loginResultDto);
        }
        if (!Objects.isNull(loginResultDto) && !Objects.isNull(loginResultDto.getError())) {
            return ReturnResult.error((IError)loginResultDto.getError());
        }
        return ReturnResult.error();
    }

    @PostMapping(value={"/applogin"})
    @ResponseBody
    public ReturnResult applogin(@RequestBody AppLoginBaseDto appLoginBaseDto, HttpServletRequest request, HttpServletResponse response) {
        String redisKey = "login:token:bysession:" + EncryptUtil.encryptStr((String)request.getSession().getId(), (EncryptTypeEnum)EncryptTypeEnum.MD5Salt);
        LoginResultDto loginResultDto = null;
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            AppAuthService appAuthService = this.serviceFactory.getAppAuthService(appLoginBaseDto.getLoginAppType());
            loginResultDto = appAuthService.appLogin(appLoginBaseDto);
            if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
            }
        } else {
            String token = this.redisUtils.getStringValue(redisKey);
            loginResultDto = new LoginResultDto();
            loginResultDto.setUserInfoDto(userInfoDto);
            loginResultDto.setError(ErrorEnum.SUCCESS);
            loginResultDto.setToken(token);
        }
        if (!Objects.isNull(loginResultDto) && loginResultDto.isSuccesss()) {
            loginResultDto.setError(null);
            loginResultDto.setExpiresIn(0L);
            return ReturnResult.success((Object)loginResultDto);
        }
        if (!Objects.isNull(loginResultDto) && !Objects.isNull(loginResultDto.getError())) {
            return ReturnResult.error((IError)loginResultDto.getError());
        }
        return ReturnResult.error();
    }

    @RequestMapping(value={"/currentUser"})
    @ResponseBody
    @AuthCheck
    public ReturnResult currentUser(HttpServletRequest request) {
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            return ReturnResult.error();
        }
        LoginResultDto loginResultDto = new LoginResultDto();
        loginResultDto.setUserInfoDto(userInfoDto);
        return ReturnResult.success((Object)loginResultDto);
    }
}

