/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.common;

import cn.gtmap.ai.core.annotation.auth.AuthCheck;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.setting.application.AiXtZdService;
import cn.gtmap.ai.core.service.setting.query.AiXtZdQuery;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/common/v1"})
public class CommonController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Value(value="${letter.yzm.use:false}")
    private boolean letterYzmUse;
    @Autowired
    private DefaultKaptcha captchaProducer;
    @Autowired
    private AiXtZdService aiXtZdService;
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;

    @GetMapping(value={"/kaptcha"})
    public void defaultKaptcha(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        byte[] captchaOutputStream = null;
        ByteArrayOutputStream imgOutputStream = new ByteArrayOutputStream();
        try {
            String verifyCode = this.captchaProducer.createText();
            httpServletRequest.getSession().setAttribute("verifyCode", (Object)verifyCode);
            BufferedImage challenge = this.captchaProducer.createImage(verifyCode);
            ImageIO.write((RenderedImage)challenge, "jpg", imgOutputStream);
        }
        catch (IllegalArgumentException e) {
            log.error("\u9519\u8bef\u539f\u56e0:{}", (Throwable)e);
            httpServletResponse.sendError(404);
            return;
        }
        captchaOutputStream = imgOutputStream.toByteArray();
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaOutputStream);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    @ResponseBody
    @PostMapping(value={"/queryXtZdList"})
    @AuthCheck
    public ReturnResult queryXtZdList(@RequestBody AiXtZdQuery aiXtZdQuery) {
        return ReturnResult.success((Object)this.aiXtZdService.queryXtZdList(aiXtZdQuery));
    }
}

