/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.exception;

import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.IError;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class BaseAssert {
    public static <T> void notNull(T t, IError code, Supplier<String> msg) {
        boolean status;
        boolean bl = status = t instanceof List && CollectionUtils.isEmpty((Collection)((List)t));
        if (null == t || status) {
            throw new BizException(code, Objects.nonNull(msg) ? msg.get() : "");
        }
    }

    public static <T> void notNull(T t, IError code) {
        boolean status;
        boolean bl = status = t instanceof List && CollectionUtils.isEmpty((Collection)((List)t));
        if (null == t || status) {
            throw new BizException(code);
        }
    }

    public static void notBlank(String s, IError code, Supplier<String> msg) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new BizException(code, Objects.nonNull(msg) ? msg.get() : "");
        }
    }

    public static void notBlank(String s, IError code) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new BizException(code);
        }
    }

    public static <T> void notNullAndBlank(T t, String s1, String s2, IError code, Supplier<String> msg) {
        if (null == t || StringUtils.isBlank((CharSequence)s1) || StringUtils.isBlank((CharSequence)s2)) {
            throw new BizException(code, Objects.nonNull(msg) ? msg.get() : "");
        }
    }

    public static void isTrue(boolean expression, IError code, Supplier<String> msg) {
        if (!expression) {
            throw new BizException(code, Objects.nonNull(msg) ? msg.get() : "");
        }
    }

    public static void isTrue(boolean expression, IError code) {
        if (!expression) {
            throw new BizException(code);
        }
    }

    public static void throwErrorByCode(IError code, Supplier<String> msg) {
        throw new BizException(code, Objects.nonNull(msg) ? msg.get() : "");
    }
}

