/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.config;

import cn.gtmap.ai.core.annotation.encrypt.FieldEncrypt;
import cn.gtmap.ai.core.annotation.encrypt.TableEncrypt;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class FieldResultSetInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(FieldResultSetInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        List list = (List)invocation.proceed();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Object item : list) {
                Field[] fields;
                TableEncrypt tableEncryptAnnotation = item.getClass().getAnnotation(TableEncrypt.class);
                if (Objects.isNull(tableEncryptAnnotation) || Objects.isNull(fields = item.getClass().getDeclaredFields())) continue;
                for (Field field : fields) {
                    FieldEncrypt fieldEncryptAnnotation = field.getAnnotation(FieldEncrypt.class);
                    if (Objects.isNull(fieldEncryptAnnotation)) continue;
                    try {
                        field.setAccessible(true);
                        String objValue = (String)field.get(item);
                        if (!StringUtils.isNotBlank((CharSequence)objValue)) continue;
                        objValue = EncryptUtil.decryptStr((String)objValue, (EncryptTypeEnum)fieldEncryptAnnotation.encryptType());
                        field.set(item, objValue);
                    }
                    catch (Exception e) {
                        log.error(" \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", item.getClass(), (Object)field.getName());
                    }
                }
            }
        }
        return list;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

