/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.config;

import cn.gtmap.ai.core.annotation.desensitization.FieldDesensitize;
import cn.gtmap.ai.core.annotation.desensitization.TableDesensitize;
import cn.gtmap.ai.core.annotation.encrypt.FieldEncrypt;
import cn.gtmap.ai.core.annotation.encrypt.TableEncrypt;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.SensitiveTypeEnum;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FieldMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(FieldMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        TableEncrypt tableEncryptAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(TableEncrypt.class);
        TableDesensitize tableDesensitizeAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(TableDesensitize.class);
        if (Objects.isNull(tableEncryptAnnotation) && Objects.isNull(tableDesensitizeAnnotation)) {
            return;
        }
        Object obj = metaObject.getOriginalObject();
        Field[] fields = metaObject.getOriginalObject().getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            FieldEncrypt fieldEncryptAnnotation = field.getAnnotation(FieldEncrypt.class);
            FieldDesensitize fieldDesensitizeAnnotation = field.getAnnotation(FieldDesensitize.class);
            try {
                String objValue;
                field.setAccessible(true);
                if (null != fieldDesensitizeAnnotation && StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) {
                    this.setFieldValByName(field.getName(), (Object)DesensitizedUtil.stringDesensitize((String)objValue, (SensitiveTypeEnum)fieldDesensitizeAnnotation.type()), metaObject);
                }
                if (null == fieldEncryptAnnotation || !StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) continue;
                this.setFieldValByName(field.getName(), (Object)EncryptUtil.encryptStr((String)objValue, (EncryptTypeEnum)fieldEncryptAnnotation.encryptType()), metaObject);
            }
            catch (Exception e) {
                log.error(" \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", metaObject.getOriginalObject().getClass(), (Object)field.getName());
            }
        }
    }

    public void updateFill(MetaObject metaObject) {
        TableEncrypt tableEncryptAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(TableEncrypt.class);
        TableDesensitize tableDesensitizeAnnotation = metaObject.getOriginalObject().getClass().getAnnotation(TableDesensitize.class);
        if (Objects.isNull(tableEncryptAnnotation) && Objects.isNull(tableDesensitizeAnnotation)) {
            return;
        }
        Object obj = metaObject.getOriginalObject();
        Field[] fields = metaObject.getOriginalObject().getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            FieldEncrypt fieldEncryptAnnotation = field.getAnnotation(FieldEncrypt.class);
            FieldDesensitize fieldDesensitizeAnnotation = field.getAnnotation(FieldDesensitize.class);
            try {
                String objValue;
                field.setAccessible(true);
                if (null != fieldDesensitizeAnnotation && StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) {
                    this.setFieldValByName(field.getName(), (Object)DesensitizedUtil.stringDesensitize((String)objValue, (SensitiveTypeEnum)fieldDesensitizeAnnotation.type()), metaObject);
                }
                if (null == fieldEncryptAnnotation || !StringUtils.isNotBlank((CharSequence)(objValue = (String)field.get(obj)))) continue;
                this.setFieldValByName(field.getName(), (Object)EncryptUtil.encryptStr((String)objValue, (EncryptTypeEnum)fieldEncryptAnnotation.encryptType()), metaObject);
            }
            catch (Exception e) {
                log.error(" \u83b7\u53d6{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", metaObject.getOriginalObject().getClass(), (Object)field.getName());
            }
        }
    }

    public TableInfo findTableInfo(MetaObject metaObject) {
        return super.findTableInfo(metaObject);
    }
}

