/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.aop;

import cn.gtmap.ai.core.base.RequestEntity;
import cn.gtmap.ai.core.base.RestReturnResultDto;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuthAop {
    private static final Logger log = LoggerFactory.getLogger(AuthAop.class);
    @Autowired
    ServiceFactory serviceFactory;

    @Pointcut(value="@annotation(cn.gtmap.ai.core.annotation.auth.AuthCheck)")
    public void authCheck() {
    }

    @Pointcut(value="@annotation(cn.gtmap.ai.core.annotation.auth.RestAuthCheck)")
    public void restAuthCheck() {
    }

    @Around(value="authCheck()")
    public Object checkAccessToken(ProceedingJoinPoint point) throws Throwable {
        ReturnResult returnResult = ReturnResult.error((IError)ErrorEnum.UN_AUTHORIZED);
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (!Objects.isNull(userInfoDto)) {
            returnResult = null;
        }
        if (!Objects.isNull(returnResult)) {
            try {
                return returnResult;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return point.proceed();
    }

    @Around(value="restAuthCheck()")
    public Object restAuthCheck(ProceedingJoinPoint point) throws Throwable {
        IError iError;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        ReturnResult returnResult = ReturnResult.error((IError)ErrorEnum.UN_AUTHORIZED);
        if (!Objects.isNull(request)) {
            UserService userService;
            UserInfoDto userInfoDto;
            AuthService authService;
            Object[] args = point.getArgs();
            String token = request.getHeader("token");
            if (StringUtils.isBlank((CharSequence)token)) {
                token = request.getParameter("token");
            }
            if (StringUtils.isNotBlank((CharSequence)token)) {
                token = token.replace(" ", "+");
            }
            if (!Objects.isNull(args)) {
                for (Object arg : args) {
                    Map head;
                    RequestEntity requestEntity;
                    if (!(arg instanceof RequestEntity) || Objects.isNull((requestEntity = (RequestEntity)arg).getHead()) || !(requestEntity.getHead() instanceof Map) || !StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)(head = (Map)requestEntity.getHead()), (Object)"access_token"))) continue;
                    token = MapUtils.getString((Map)head, (Object)"access_token");
                    break;
                }
            }
            if ((iError = (authService = this.serviceFactory.getAuthService()).checkToken(token)).isSuccesss() && !Objects.isNull(userInfoDto = (userService = this.serviceFactory.getUserService()).getUserByToken(token))) {
                returnResult = null;
            }
        }
        if (!Objects.isNull(returnResult)) {
            MethodSignature signature = (MethodSignature)point.getSignature();
            Class<?> returnType = signature.getMethod().getReturnType();
            if (Objects.isNull(returnType)) {
                HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                try (ServletOutputStream servletOutputStream = response.getOutputStream();){
                    servletOutputStream.write(returnResult.getMessage().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    log.error("{} \u8bf7\u6c42\u8fd4\u56de\u503c\u5f02\u5e38", (Object)request.getRequestURL(), (Object)e);
                }
            } else if (returnType.getName().equals(ReturnResult.class.getName())) {
                try {
                    return returnResult;
                }
                catch (Exception e) {
                    log.error("{} \u8bf7\u6c42\u8fd4\u56de\u503c\u5f02\u5e38", (Object)request.getRequestURL(), (Object)e);
                }
            } else if (returnType.getName().equals(RestReturnResultDto.class.getName())) {
                try {
                    ReturnResult finalReturnResult = returnResult;
                    iError = new /* Unavailable Anonymous Inner Class!! */;
                    return RestReturnResultDto.error((IError)iError);
                }
                catch (Exception e) {
                    log.error("{} \u8bf7\u6c42\u8fd4\u56de\u503c\u5f02\u5e38", (Object)request.getRequestURL(), (Object)e);
                }
            }
            return null;
        }
        return point.proceed();
    }
}

